/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class FirewallQuarantineTimestampTask
extends TaskSupport
implements Cancelable {
    private final RepositoryManager repositoryManager;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final long quarantineTimestamp;

    @Inject
    public FirewallQuarantineTimestampTask(RepositoryManager repositoryManager, RepositoryAttributeStorage repositoryAttributeStorage, @Named(value="${nexus.firewall.quarantineFix.quarantineTimestamp:-559872000000}") @Named(value="${nexus.firewall.quarantineFix.quarantineTimestamp:-559872000000}") long quarantineTimestamp) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.quarantineTimestamp = quarantineTimestamp;
    }

    public String getMessage() {
        return "Resetting quarantine enabled timestamp in ALL repositories";
    }

    protected Object execute() throws Exception {
        for (Repository repository : this.repositoryManager.browse()) {
            this.maybeUpdateQuarantineEnabledTimestamp(repository);
        }
        return null;
    }

    private void maybeUpdateQuarantineEnabledTimestamp(Repository repository) {
        String repositoryName = repository.getName();
        if (this.repositoryAttributeStorage.isQuarantineEnabled(repositoryName)) {
            this.log.info("Quarantine enabled for repository {}, will update REPOSITORY_QUARANTINE_ENABLED_TIMESTAMP_KEY", (Object)repositoryName);
            this.repositoryAttributeStorage.forceSetQuarantineEnabled(repositoryName, true, this.quarantineTimestamp);
        } else {
            this.log.debug("Quarantine NOT enabled for repository {}, will apply no updates.", (Object)repositoryName);
        }
    }
}

