/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.synchronization.polling;

import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.firewall.onboarding.client.FirewallOnboardingClient;
import com.sonatype.nexus.clm.firewall.onboarding.client.FirewallOnboardingClientHelper;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingStateSynchronization;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingSynchronizationService;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class PollingFirewallOnboardingSynchronizationService
extends ComponentSupport
implements FirewallOnboardingSynchronizationService {
    private final AtomicBoolean active = new AtomicBoolean();
    private final FirewallOnboardingClient firewallOnboardingClient;
    private final FirewallOnboardingClientHelper firewallOnboardingClientHelper;
    private final FirewallOnboardingStateSynchronization firewallOnboardingStateSynchronization;

    @Inject
    public PollingFirewallOnboardingSynchronizationService(FirewallOnboardingClient firewallOnboardingClient, FirewallOnboardingClientHelper firewallOnboardingClientHelper, FirewallOnboardingStateSynchronization firewallOnboardingStateSynchronization) {
        this.firewallOnboardingClient = Objects.requireNonNull(firewallOnboardingClient);
        this.firewallOnboardingClientHelper = Objects.requireNonNull(firewallOnboardingClientHelper);
        this.firewallOnboardingStateSynchronization = Objects.requireNonNull(firewallOnboardingStateSynchronization);
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public void doSynchronization() {
        this.active.set(true);
        long lastSynchronizationTimestamp = this.firewallOnboardingStateSynchronization.getLastSynchronizationTimestamp();
        try {
            Map.Entry<StatusLine, List<RepositoryDTO>> result = this.getConfiguredRepositories(lastSynchronizationTimestamp);
            StatusLine statusLine = result.getKey();
            if (statusLine.getStatusCode() == 200) {
                this.firewallOnboardingStateSynchronization.synchronize(result.getValue());
            } else if (statusLine.getStatusCode() == 404) {
                this.log.warn("Firewall onboarding 'getConfigurationChanges' endpoint respond 404(Not found). Firewall might not support the endpoint yet.");
            } else {
                this.log.debug("Unable to process such case. Firewall 'getConfigurationChanges' endpoint respond {} lastSynchronizationTimestamp {}.", (Object)statusLine.getStatusCode(), (Object)lastSynchronizationTimestamp);
            }
        }
        catch (Exception e) {
            this.log.error("Firewall onboarding synchronization error", (Throwable)e);
        }
        this.active.set(false);
    }

    private Map.Entry<StatusLine, List<RepositoryDTO>> getConfiguredRepositories(long lastSynchronizationTimestamp) throws Exception {
        Throwable throwable = null;
        Object var4_4 = null;
        try (CloseableHttpResponse response = this.firewallOnboardingClient.getConfigurationChanges(lastSynchronizationTimestamp);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                return new AbstractMap.SimpleEntry<StatusLine, List<RepositoryDTO>>(statusLine, this.firewallOnboardingClientHelper.deserialize(() -> response.getEntity().getContent()));
            }
            return new AbstractMap.SimpleEntry<StatusLine, List<RepositoryDTO>>(statusLine, Collections.emptyList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

