/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.synchronization;

import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingStateSynchronizationProcedure;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class NpmProxyRemoveQuarantinedVersionsFirewallOnboardingStateSynchronizationProcedure
extends ComponentSupport
implements FirewallOnboardingStateSynchronizationProcedure {
    private static final String NPM_FORMAT_NAME = "npm";
    private static final String NPM_REMOVE_QUARANTINED_KEY = "removeQuarantinedVersions";
    private final RepositoryManager repositoryManager;

    @Inject
    public NpmProxyRemoveQuarantinedVersionsFirewallOnboardingStateSynchronizationProcedure(RepositoryManager repositoryManager) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
    }

    @Override
    public boolean consume(RepositoryDTO repositoryDTO) throws Exception {
        Repository repository = this.repositoryManager.get(repositoryDTO.name);
        if (repository == null) {
            this.log.debug("There is no such repository {}.", (Object)repositoryDTO.name);
            return false;
        }
        if (!this.isNpmProxy(repository)) {
            return false;
        }
        Object removeQuarantinedVersionsObjectCurrent = repository.getConfiguration().attributes(NPM_FORMAT_NAME).get(NPM_REMOVE_QUARANTINED_KEY, (Object)false);
        boolean removeQuarantinedVersionsCurrent = Boolean.parseBoolean(Objects.requireNonNull(removeQuarantinedVersionsObjectCurrent).toString());
        if (removeQuarantinedVersionsCurrent == repositoryDTO.policyCompliantComponentSelectionEnabled) {
            this.log.debug("Repository {} state has not been changed. There are no changes to apply.", (Object)repositoryDTO.name);
            return false;
        }
        this.log.info("Applying removeQuarantinedVersions. Repository {}. Prev state {}. Next state {}.", new Object[]{repositoryDTO.name, removeQuarantinedVersionsCurrent, repositoryDTO.policyCompliantComponentSelectionEnabled});
        Configuration newConfiguration = repository.getConfiguration().copy();
        newConfiguration.attributes(NPM_FORMAT_NAME).set(NPM_REMOVE_QUARANTINED_KEY, (Object)repositoryDTO.policyCompliantComponentSelectionEnabled);
        this.repositoryManager.update(newConfiguration);
        this.log.info("Applying removeQuarantinedVersions has been finished. Repository {}.", (Object)repositoryDTO.name);
        return true;
    }

    private boolean isNpmProxy(Repository repository) {
        return repository.getFormat().getValue().equals(NPM_FORMAT_NAME) && repository.getType().getValue().equals("proxy");
    }
}

