/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.synchronization;

import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingStateSynchronizationProcedure;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class HostedProprietaryComponentsFirewallOnboardingStateSynchronizationProcedure
extends ComponentSupport
implements FirewallOnboardingStateSynchronizationProcedure {
    private static final String COMPONENT_FIELD = "component";
    private static final String PROPRIETARY_COMPONENTS = "proprietaryComponents";
    private final RepositoryManager repositoryManager;

    @Inject
    public HostedProprietaryComponentsFirewallOnboardingStateSynchronizationProcedure(RepositoryManager repositoryManager) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
    }

    @Override
    public boolean consume(RepositoryDTO repositoryDTO) throws Exception {
        Repository repository = this.repositoryManager.get(repositoryDTO.name);
        if (repository == null) {
            this.log.debug("There is no such repository {}", (Object)repositoryDTO.name);
            return false;
        }
        if (!repository.getType().getValue().equals("hosted")) {
            return false;
        }
        Object proprietaryComponentsObjectCurrent = repository.getConfiguration().attributes(COMPONENT_FIELD).get(PROPRIETARY_COMPONENTS, (Object)false);
        boolean proprietaryComponentsCurrent = Boolean.parseBoolean(Objects.requireNonNull(proprietaryComponentsObjectCurrent).toString());
        if (proprietaryComponentsCurrent == repositoryDTO.namespaceConfusionProtectionEnabled) {
            this.log.debug("Repository {} state has not been changed. There are no changes to apply.", (Object)repositoryDTO.name);
            return false;
        }
        this.log.info("Applying proprietaryComponents. Repository {}. Prev state {}. Next state {}.", new Object[]{repository.getName(), proprietaryComponentsCurrent, repositoryDTO.namespaceConfusionProtectionEnabled});
        Configuration newConfiguration = repository.getConfiguration().copy();
        newConfiguration.attributes(COMPONENT_FIELD).set(PROPRIETARY_COMPONENTS, (Object)repositoryDTO.namespaceConfusionProtectionEnabled);
        this.repositoryManager.update(newConfiguration);
        this.log.info("Applying proprietaryComponents has been finished. Repository {}.", (Object)repositoryDTO.name);
        return true;
    }
}

