/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.synchronization;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.firewall.onboarding.FirewallOnboardingManager;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class FirewallOnboardingSynchronizationTaskManager
extends ComponentSupport {
    static final String TASK_NAME = "Firewall onboarding synchronization task";
    private final String cronSchedule;
    private final TaskScheduler taskScheduler;
    private final FirewallOnboardingManager firewallOnboardingManager;

    @Inject
    public FirewallOnboardingSynchronizationTaskManager(TaskScheduler taskScheduler, @Named(value="${nexus.firewall.onboarding.polling.cron_schedule:-*/10 * * * * ?}") @Named(value="${nexus.firewall.onboarding.polling.cron_schedule:-*/10 * * * * ?}") String cronSchedule, FirewallOnboardingManager firewallOnboardingManager) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.cronSchedule = (String)Preconditions.checkNotNull((Object)cronSchedule);
        this.firewallOnboardingManager = (FirewallOnboardingManager)((Object)Preconditions.checkNotNull((Object)((Object)firewallOnboardingManager)));
    }

    public void scheduleTask() {
        if (!this.doesTaskExist() && this.firewallOnboardingManager.isOnboardingReadyToWork()) {
            TaskConfiguration taskConfig = this.taskScheduler.createTaskConfigurationInstance("firewall.onboarding.synchronization");
            taskConfig.setName(TASK_NAME);
            taskConfig.setLogTaskState(false);
            Cron cron = this.taskScheduler.getScheduleFactory().cron(new Date(), this.cronSchedule);
            this.taskScheduler.scheduleTask(taskConfig, (Schedule)cron);
            this.log.debug("Firewall Onboarding Synchronization Task scheduled");
        }
    }

    public void removeScheduledTask() {
        Optional<TaskInfo> task = this.taskScheduler.listsTasks().stream().filter(this::isFirewallOnboardingSynchronizationTask).findAny();
        task.ifPresent(TaskInfo::remove);
    }

    private boolean doesTaskExist() {
        return this.taskScheduler.listsTasks().stream().anyMatch(this::isFirewallOnboardingSynchronizationTask);
    }

    private boolean isFirewallOnboardingSynchronizationTask(TaskInfo info) {
        return "firewall.onboarding.synchronization".equals(info.getConfiguration().getTypeId());
    }
}

