/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.synchronization;

import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingStateSynchronizationProcedure;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cache.CacheManager;
import org.sonatype.nexus.cache.NexusCache;

@Named
public class FirewallOnboardingStateSynchronization
extends ComponentSupport {
    public static final String CACHE_NAME = "FIREWALL.ONBOARDING.SYNCHRONIZATION.TASK";
    public static final String CACHE_KEY = "LAST_SYNCHRONIZATION_TIMESTAMP";
    public static final Duration CACHE_EXPIRE_AFTER = new Duration(TimeUnit.DAYS, 365L);
    private final List<FirewallOnboardingStateSynchronizationProcedure> stateSynchronizationProcedures;
    private final CacheManager<String, String> cacheManager;
    private volatile NexusCache<String, String> lastSynchronizationTimestampCache;

    @Inject
    public FirewallOnboardingStateSynchronization(List<FirewallOnboardingStateSynchronizationProcedure> stateSynchronizationProcedures, CacheManager<String, String> cacheManager) {
        this.stateSynchronizationProcedures = Objects.requireNonNull(stateSynchronizationProcedures);
        this.cacheManager = Objects.requireNonNull(cacheManager);
    }

    public void synchronize(List<RepositoryDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.log.debug("Synchronizing repository size {} lastSynchronizationTimestamp {}.", (Object)list.size(), (Object)this.getLastSynchronizationTimestamp());
        boolean wereAnyRepositoryUpdated = false;
        for (RepositoryDTO repositoryDTO : list) {
            this.log.debug("Synchronizing repository {} lastSynchronizationTimestamp {}.", (Object)repositoryDTO.name, (Object)this.getLastSynchronizationTimestamp());
            for (FirewallOnboardingStateSynchronizationProcedure procedure : this.stateSynchronizationProcedures) {
                try {
                    boolean updated = procedure.consume(repositoryDTO);
                    wereAnyRepositoryUpdated = wereAnyRepositoryUpdated || updated;
                }
                catch (Exception e) {
                    this.log.error("State synchronization procedure error '{}' lastSynchronizationTimestamp {}.", new Object[]{e.getMessage(), this.getLastSynchronizationTimestamp(), this.log.isDebugEnabled() ? e : null});
                }
            }
        }
        this.log.debug("Synchronizing has been finished repository size {} lastSynchronizationTimestamp {}.", (Object)list.size(), (Object)this.getLastSynchronizationTimestamp());
        if (wereAnyRepositoryUpdated) {
            this.putLastSynchronizationTimestamp(System.currentTimeMillis());
        }
    }

    private void maybeCreateCache() {
        if (this.lastSynchronizationTimestampCache == null) {
            this.log.debug("Creating {} cache", (Object)CACHE_NAME);
            this.lastSynchronizationTimestampCache = this.cacheManager.getCache(CACHE_NAME, String.class, String.class, CACHE_EXPIRE_AFTER);
            this.log.debug("Created {} cache", (Object)CACHE_NAME);
        }
    }

    public Long getLastSynchronizationTimestamp() {
        this.maybeCreateCache();
        return this.lastSynchronizationTimestampCache.get((Object)CACHE_KEY).map(Long::parseLong).orElse(0L);
    }

    protected void putLastSynchronizationTimestamp(Long lastSynchronizationTimestamp) {
        this.maybeCreateCache();
        this.lastSynchronizationTimestampCache.put((Object)CACHE_KEY, (Object)lastSynchronizationTimestamp.toString());
    }
}

