/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.synchronization;

import com.google.common.base.Predicate;
import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingStateSynchronizationProcedure;
import com.sonatype.nexus.clm.internal.capability.FirewallAuditCapabilityDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;

@Named
@Singleton
public class FirewallAuditCapabilityFirewallOnboardingStateSynchronizationProcedure
extends ComponentSupport
implements FirewallOnboardingStateSynchronizationProcedure {
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public FirewallAuditCapabilityFirewallOnboardingStateSynchronizationProcedure(CapabilityRegistry capabilityRegistry) {
        this.capabilityRegistry = Objects.requireNonNull(capabilityRegistry);
    }

    @Override
    public boolean consume(RepositoryDTO repositoryDTO) {
        CapabilityReference firewallAuditCapability = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(FirewallAuditCapabilityDescriptor.TYPE).withProperty("repository", repositoryDTO.name)).stream().findFirst().orElse(null);
        if (firewallAuditCapability == null) {
            this.create(repositoryDTO);
            return true;
        }
        return this.update(firewallAuditCapability, repositoryDTO);
    }

    private void create(RepositoryDTO repositoryDTO) {
        if (!repositoryDTO.auditEnabled) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("repository", repositoryDTO.name);
        properties.put("quarantine", String.valueOf(repositoryDTO.quarantineEnabled));
        this.log.debug("Creating. Capability '{}' repository {}. Audit {}. Quarantine {}.", new Object[]{FirewallAuditCapabilityDescriptor.TYPE, properties.get("repository"), true, properties.get("quarantine")});
        this.capabilityRegistry.add(FirewallAuditCapabilityDescriptor.TYPE, true, null, properties);
    }

    private boolean update(CapabilityReference firewallAuditCapability, RepositoryDTO repositoryDTO) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(firewallAuditCapability.context().properties());
        boolean repositoryQuarantineCurrent = Boolean.parseBoolean((String)properties.get("quarantine"));
        boolean enabledCapabilityCurrent = firewallAuditCapability.context().isEnabled();
        if (enabledCapabilityCurrent == repositoryDTO.auditEnabled && repositoryQuarantineCurrent == repositoryDTO.quarantineEnabled) {
            this.log.debug("Capability '{}' repository {} state has not been changed. There are no changes to apply.", (Object)firewallAuditCapability.context().type(), properties.get("repository"));
            return false;
        }
        properties.put("quarantine", String.valueOf(repositoryDTO.quarantineEnabled));
        this.log.info("Applying. Capability '{}' repository {}. Prev Audit {}. Next Audit {}. Prev Quarantine {}. Next Quarantine {}.", new Object[]{firewallAuditCapability.context().type(), properties.get("repository"), enabledCapabilityCurrent, repositoryDTO.auditEnabled, repositoryQuarantineCurrent, repositoryDTO.quarantineEnabled});
        this.capabilityRegistry.update(firewallAuditCapability.context().id(), repositoryDTO.auditEnabled, firewallAuditCapability.context().notes(), properties);
        this.log.info("Applying has been finished. Capability '{}' repository {}.", (Object)firewallAuditCapability.context().type(), properties.get("repository"));
        return true;
    }
}

