/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.listener;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.firewall.onboarding.FirewallOnboardingManager;
import com.sonatype.nexus.clm.firewall.onboarding.synchronization.FirewallOnboardingSynchronizationTaskManager;
import com.sonatype.nexus.clm.internal.capability.ClmCapability;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.manager.RepositoryCreatedEvent;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class FirewallOnboardingEventListener
extends StateGuardLifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private final FirewallOnboardingManager firewallOnboardingManager;
    private final FirewallOnboardingSynchronizationTaskManager firewallOnboardingSynchronizationTaskManager;

    @Inject
    public FirewallOnboardingEventListener(FirewallOnboardingManager firewallOnboardingManager, FirewallOnboardingSynchronizationTaskManager firewallOnboardingSynchronizationTaskManager) {
        this.firewallOnboardingManager = Objects.requireNonNull(firewallOnboardingManager);
        this.firewallOnboardingSynchronizationTaskManager = Objects.requireNonNull(firewallOnboardingSynchronizationTaskManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterActivated event) {
        if (event.getReference().capability() instanceof ClmCapability) {
            this.firewallOnboardingManager.expireCache();
            this.firewallOnboardingManager.sendRepositories();
            this.firewallOnboardingSynchronizationTaskManager.scheduleTask();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterUpdate event) {
        if (event.getReference().capability() instanceof ClmCapability) {
            this.firewallOnboardingManager.expireCache();
            this.firewallOnboardingManager.sendRepositories();
            this.firewallOnboardingSynchronizationTaskManager.scheduleTask();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.AfterRemove event) {
        if (event.getReference().capability() instanceof ClmCapability && this.getStateGuard().is("STARTED")) {
            this.firewallOnboardingSynchronizationTaskManager.removeScheduledTask();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent.BeforePassivated event) {
        if (event.getReference().capability() instanceof ClmCapability && this.getStateGuard().is("STARTED")) {
            this.firewallOnboardingSynchronizationTaskManager.removeScheduledTask();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryCreatedEvent event) {
        this.firewallOnboardingManager.repositoryCreated(event.getRepository());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryDeletedEvent event) {
        this.firewallOnboardingManager.repositoryDeleted(event.getRepository());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryUpdatedEvent event) {
        this.firewallOnboardingManager.repositoryUpdated(event.getRepository());
    }
}

