/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.clm.dto.model.repository.RepositoryType;
import com.sonatype.nexus.clm.internal.capability.FirewallAuditCapabilityDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;

@Named
@Singleton
public class FirewallOnboardingClientHelper {
    private static final TypeReference<List<RepositoryDTO>> TYPE_REFERENCE_LIST_REPOSITORY_DTO = new TypeReference<List<RepositoryDTO>>(){};
    private static final String REMOVE_QUARANTINED_KEY = "removeQuarantinedVersions";
    private static final String COMPONENT_FIELD = "component";
    private static final String PROPRIETARY_COMPONENTS = "proprietaryComponents";
    private static final String NPM_FORMAT_NAME = "npm";
    private final CapabilityRegistry capabilityRegistry;
    private final ObjectMapper objectMapper;

    @Inject
    public FirewallOnboardingClientHelper(CapabilityRegistry capabilityRegistry, ObjectMapper objectMapper) {
        this.capabilityRegistry = Objects.requireNonNull(capabilityRegistry);
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public List<RepositoryDTO> deserialize(InputStreamSupplier inputStreamSupplier) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = inputStreamSupplier.get();){
            return (List)this.objectMapper.readValue(inputStream, TYPE_REFERENCE_LIST_REPOSITORY_DTO);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<RepositoryDTO> toRepositoryDTO(Iterable<Repository> repositories) {
        return StreamSupport.stream(repositories.spliterator(), false).map(this::toRepositoryDTO).collect(Collectors.toList());
    }

    private RepositoryDTO toRepositoryDTO(Repository repository) {
        RepositoryDTO repositoryDTO = new RepositoryDTO();
        repositoryDTO.name = repository.getName();
        repositoryDTO.format = repository.getFormat().getValue();
        repositoryDTO.type = RepositoryType.valueOf((String)repository.getType().getValue());
        if ("proxy".equals(repository.getType().getValue())) {
            this.fillFirewallAuditCapabilityProperties(repositoryDTO);
            repositoryDTO.policyCompliantComponentSelectionEnabled = Boolean.TRUE.equals(repository.getConfiguration().attributes(NPM_FORMAT_NAME).get(REMOVE_QUARANTINED_KEY, Boolean.class));
        }
        if ("hosted".equals(repository.getType().getValue())) {
            repositoryDTO.namespaceConfusionProtectionEnabled = Boolean.TRUE.equals(repository.getConfiguration().attributes(COMPONENT_FIELD).get(PROPRIETARY_COMPONENTS, Boolean.class));
        }
        return repositoryDTO;
    }

    private void fillFirewallAuditCapabilityProperties(RepositoryDTO repositoryDTO) {
        this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(FirewallAuditCapabilityDescriptor.TYPE).withProperty("repository", repositoryDTO.name).enabled()).stream().findFirst().ifPresent(capability -> {
            repositoryDTO.auditEnabled = true;
            repositoryDTO.quarantineEnabled = this.parseBoolean((String)capability.context().properties().get("quarantine"), false);
        });
    }

    private Boolean parseBoolean(@Nullable String value, @Nullable Boolean defaultValue) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

