/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.clm.dto.model.repository.ConfigureRepositoriesRequest;
import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.ClmConnector;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.node.DeploymentAccess;

@Named
@Singleton
public class FirewallOnboardingClient {
    private static final TypeReference<Map<String, Object>> JSON_RAW_MAP = new TypeReference<Map<String, Object>>(){};
    private static final String REST_PRODUCT_VERSION = "rest/product/version";
    private static final String REST_INTEGRATION_REPOSITORIES = "rest/integration/repositories";
    private static final String PRODUCT_VERSION_PROPERTY_KEY = "version";
    private static final String CONFIGURE_REPOSITORIES = "configureRepositories";
    private static final String GET_CONFIGURED_REPOSITORIES = "getConfiguredRepositories";
    private static final String NEXUS = "Nexus";
    private final ClmConnector clmConnector;
    private final DeploymentAccess deploymentAccess;
    private final ObjectMapper objectMapper;
    private final ApplicationVersion applicationVersion;

    @Inject
    public FirewallOnboardingClient(ClmConnector clmConnector, DeploymentAccess deploymentAccess, ObjectMapper objectMapper, ApplicationVersion applicationVersion) {
        this.clmConnector = Objects.requireNonNull(clmConnector);
        this.deploymentAccess = Objects.requireNonNull(deploymentAccess);
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.applicationVersion = Objects.requireNonNull(applicationVersion);
    }

    public Optional<String> getProductVersion() throws IOException {
        return Optional.of(this.getProductProperties()).map(properties -> properties.get(PRODUCT_VERSION_PROPERTY_KEY)).map(Object::toString);
    }

    public Map<String, Object> getProductProperties() throws IOException {
        HttpGet request = this.buildGetProperties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (CloseableHttpResponse response = this.sendFirewallOnboardingRequest((HttpUriRequest)request);){
            if (response.getStatusLine().getStatusCode() != 200) {
                return Collections.emptyMap();
            }
            return (Map)this.objectMapper.readValue(response.getEntity().getContent(), JSON_RAW_MAP);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public CloseableHttpResponse sendRepositories(List<RepositoryDTO> repositoryDTOS) throws IOException {
        HttpPost httpPost = this.buildPostRequestSendRepositories(repositoryDTOS);
        return this.sendFirewallOnboardingRequest((HttpUriRequest)httpPost);
    }

    public CloseableHttpResponse sendDeletedRepository(String repositoryId) throws IOException {
        HttpDelete httpDelete = this.buildDeleteRequestSendDeletedRepositories(repositoryId);
        return this.sendFirewallOnboardingRequest((HttpUriRequest)httpDelete);
    }

    public CloseableHttpResponse getConfigurationChanges(long timestamp) throws URISyntaxException, IOException {
        String url = String.format("%s/%s/%s/%s", this.getIqServerURL(), REST_INTEGRATION_REPOSITORIES, this.deploymentAccess.getId(), GET_CONFIGURED_REPOSITORIES);
        URI uri = new URIBuilder(url).addParameter("sinceUtcTimestamp", String.valueOf(timestamp)).build();
        HttpGet httpGet = new HttpGet(uri);
        return this.sendFirewallOnboardingRequest((HttpUriRequest)httpGet);
    }

    private HttpGet buildGetProperties() {
        String url = String.format("%s/%s", this.getIqServerURL(), REST_PRODUCT_VERSION);
        return new HttpGet(url);
    }

    private HttpPost buildPostRequestSendRepositories(List<RepositoryDTO> repositoryDTOS) {
        String url = String.format("%s/%s/%s/%s", this.getIqServerURL(), REST_INTEGRATION_REPOSITORIES, this.deploymentAccess.getId(), CONFIGURE_REPOSITORIES);
        HttpPost post = new HttpPost(url);
        EntityBuilder builder = EntityBuilder.create();
        ConfigureRepositoriesRequest dto = new ConfigureRepositoriesRequest(NEXUS, this.applicationVersion.getVersion(), repositoryDTOS);
        builder.setText(this.asJson(dto));
        builder.setContentType(ContentType.APPLICATION_JSON);
        post.setEntity(builder.build());
        return post;
    }

    private HttpDelete buildDeleteRequestSendDeletedRepositories(String repositoryId) {
        String url = String.format("%s/%s/%s/%s", this.getIqServerURL(), REST_INTEGRATION_REPOSITORIES, this.deploymentAccess.getId(), repositoryId);
        HttpDelete delete = new HttpDelete(url);
        return delete;
    }

    private String asJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getIqServerURL() {
        return StringUtils.strip((String)this.clmConnector.getRestConfiguration().getServerUrl(), (String)"/");
    }

    private CloseableHttpResponse sendFirewallOnboardingRequest(HttpUriRequest request) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CloseableHttpClient client = this.clmConnector.createHttpClientBuilder().build();){
            return client.execute(request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

