/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.onboarding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.sonatype.clm.dto.model.repository.RepositoryDTO;
import com.sonatype.nexus.clm.firewall.onboarding.client.FirewallOnboardingClient;
import com.sonatype.nexus.clm.firewall.onboarding.client.FirewallOnboardingClientHelper;
import com.sonatype.nexus.clm.internal.capability.ClmCapabilityDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class FirewallOnboardingManager
extends ComponentSupport {
    private static final String MINIMUM_ONBOARDING_PRODUCT_VERSION = "1.167.0";
    private final AtomicReference<String> firewallProductVersion = new AtomicReference();
    private final RepositoryManager repositoryManager;
    private final FirewallOnboardingClientHelper firewallOnboardingClientHelper;
    private final FirewallOnboardingClient firewallOnboardingClient;
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public FirewallOnboardingManager(RepositoryManager repositoryManager, FirewallOnboardingClientHelper firewallOnboardingClientHelper, FirewallOnboardingClient firewallOnboardingClient, CapabilityRegistry capabilityRegistry) {
        this.firewallOnboardingClientHelper = Objects.requireNonNull(firewallOnboardingClientHelper);
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.firewallOnboardingClient = Objects.requireNonNull(firewallOnboardingClient);
        this.capabilityRegistry = Objects.requireNonNull(capabilityRegistry);
    }

    public void sendRepositories() {
        if (!this.isOnboardingReadyToWork()) {
            return;
        }
        List<Repository> repositories = this.getProxyAndHostedRepositories();
        List<RepositoryDTO> repositoryDTOS = this.firewallOnboardingClientHelper.toRepositoryDTO(repositories);
        this.sendRepositories(repositoryDTOS);
    }

    public void repositoryCreated(Repository repository) {
        if (!this.isOnboardingReadyToWork() || !this.isRelevantRepositoryType(repository.getType())) {
            return;
        }
        List<RepositoryDTO> repositoryDTOS = this.firewallOnboardingClientHelper.toRepositoryDTO(Collections.singleton(repository));
        this.sendRepositories(repositoryDTOS);
    }

    public void repositoryUpdated(Repository repository) {
        if (!this.isOnboardingReadyToWork() || !this.isRelevantRepositoryType(repository.getType())) {
            return;
        }
        List<RepositoryDTO> repositoryDTOS = this.firewallOnboardingClientHelper.toRepositoryDTO(Collections.singleton(repository));
        this.sendRepositories(repositoryDTOS);
    }

    private void sendRepositories(List<RepositoryDTO> repositoryDTOS) {
        if (CollectionUtils.isEmpty(repositoryDTOS)) {
            this.log.debug("There are no repositories to send. Skipping 'send repositories' operation");
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpResponse response = this.firewallOnboardingClient.sendRepositories(repositoryDTOS);){
                if (204 == response.getStatusLine().getStatusCode()) {
                    this.log.info("Send repositories to Firewall succeeded.");
                } else if (404 == response.getStatusLine().getStatusCode()) {
                    this.log.warn("Failed to send repositories to Firewall. Firewall might not support the endpoint yet.");
                } else {
                    this.log.debug("Failed to send repositories to Firewall. Cause {} {}", (Object)response.getStatusLine().getStatusCode(), repositoryDTOS);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Send repositories got error {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
    }

    private List<Repository> getProxyAndHostedRepositories() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(repository -> this.isRelevantRepositoryType(repository.getType())).collect(Collectors.toList());
    }

    private boolean isRelevantRepositoryType(Type type) {
        String typeValue = type.getValue();
        return "hosted".equals(typeValue) || "proxy".equals(typeValue);
    }

    private boolean isClmCapabilityEnabled() {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(ClmCapabilityDescriptor.TYPE).includeNotExposed()).stream().findFirst().map(capabilityReference -> capabilityReference.context().isEnabled()).orElse(false);
    }

    public boolean doesInstanceSupportOnboardingFeature() {
        String version = this.getProductVersion();
        return StringUtils.isNotEmpty((CharSequence)version) && VersionComparator.INSTANCE.compare(version, MINIMUM_ONBOARDING_PRODUCT_VERSION) >= 0;
    }

    @VisibleForTesting
    protected String getProductVersion() {
        String currentProductVersion = this.firewallProductVersion.get();
        if (currentProductVersion != null) {
            return currentProductVersion;
        }
        String productVersion = this.doGetProductVersion().orElse("");
        this.firewallProductVersion.set(productVersion);
        return productVersion;
    }

    private Optional<String> doGetProductVersion() {
        try {
            return this.firewallOnboardingClient.getProductVersion();
        }
        catch (IOException e) {
            this.log.debug("Unable to get firewall product version {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
            return Optional.empty();
        }
    }

    public boolean isOnboardingReadyToWork() {
        return this.isClmCapabilityEnabled() && this.doesInstanceSupportOnboardingFeature();
    }

    public void repositoryDeleted(Repository repository) {
        if (!this.isOnboardingReadyToWork() || !this.isRelevantRepositoryType(repository.getType())) {
            return;
        }
        this.sendDeletedRepository(repository.getName());
    }

    private void sendDeletedRepository(String repositoryId) {
        if (repositoryId != null && repositoryId.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CloseableHttpResponse response = this.firewallOnboardingClient.sendDeletedRepository(repositoryId);){
                if (204 == response.getStatusLine().getStatusCode()) {
                    this.log.info("Send deleted repository to Firewall succeeded.");
                } else if (404 == response.getStatusLine().getStatusCode()) {
                    this.log.warn("Failed to send repositories to Firewall. Firewall might not support the endpoint yet.");
                } else {
                    this.log.debug("Failed to send repositories to Firewall. Cause {} {}", (Object)response.getStatusLine().getStatusCode(), (Object)repositoryId);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.error("Send deleted repositories got error {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
    }

    public void expireCache() {
        this.firewallProductVersion.set(null);
    }
}

