/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

public class FirewallComponentVersionsApi
extends ComponentSupport {
    private static final String QUARANTINED_COMPONENTS_BY_REPOSITORY_PATH_REST_API = "/api/v2/repositories/%s/%s/components/quarantined/pathnames";
    private static final Gson gson = new GsonBuilder().create();

    public QuarantinedComponentVersionsResponse getComponentVersions(ClmService clmService, String repositoryManagerId, String repositoryId, List<String> pathNames) throws InternalException {
        String jsonRequest = gson.toJson(pathNames);
        this.log.trace("IQ Request for component versions: {}", (Object)jsonRequest);
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (InputStream is = clmService.executePostAndHandleResponse(jsonRequest, String.format(QUARANTINED_COMPONENTS_BY_REPOSITORY_PATH_REST_API, repositoryManagerId, repositoryId));){
                String json = IOUtils.toString((InputStream)is);
                this.log.trace("IQ Response for component versions: {}", (Object)json);
                return (QuarantinedComponentVersionsResponse)gson.fromJson(json, QuarantinedComponentVersionsResponse.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CompatibilityException e) {
            this.log.debug("IQ Server version 125+ is required for auditing quarantined component versions.", (Throwable)e);
            throw new InternalException("IQ Server version 125+ is required for auditing quarantined component versions");
        }
        catch (Exception e) {
            this.log.debug("Error getting component versions", (Throwable)e);
            throw new InternalException("Error getting component versions");
        }
    }

    public static final class QuarantinedComponentVersionsResponse {
        public List<RepositoryPathVersions> pathVersions = new ArrayList<RepositoryPathVersions>();
    }

    public static class RepositoryComponentPath {
        private String pathname;
        private boolean quarantine;

        public String getPathname() {
            return this.pathname;
        }

        public boolean isQuarantine() {
            return this.quarantine;
        }
    }

    public static class RepositoryPathVersions {
        public int requestIndex;
        public List<RepositoryComponentPath> repositoryComponentPaths = new ArrayList<RepositoryComponentPath>();
    }
}

