/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.firewall.api.FirewallComponentVersionsApi;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.repository.firewall.event.QuarantinedComponentVersions;
import org.sonatype.nexus.repository.firewall.event.QuarantinedComponentVersionsRequest;
import org.sonatype.nexus.repository.vulnerability.AuditRepositoryComponent;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.ConfigurationException;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

@Named
@Singleton
public class QuarantinedComponentsListener
extends ComponentSupport
implements EventAware {
    private final ClmConnector clmConnector;
    private final Provider<ClmService> clmServiceProvider;
    private final DeploymentAccess deploymentAccess;
    private final FirewallComponentVersionsApi firewallComponentVersionsApi;

    @Inject
    public QuarantinedComponentsListener(ClmConnector clmConnector, Provider<ClmService> clmServiceProvider, DeploymentAccess deploymentAccess, FirewallComponentVersionsApi firewallComponentVersionsApi) {
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.clmServiceProvider = (Provider)Preconditions.checkNotNull(clmServiceProvider);
        this.deploymentAccess = (DeploymentAccess)Preconditions.checkNotNull((Object)deploymentAccess);
        this.firewallComponentVersionsApi = (FirewallComponentVersionsApi)((Object)Preconditions.checkNotNull((Object)((Object)firewallComponentVersionsApi)));
    }

    @Subscribe
    public void on(QuarantinedComponentVersionsRequest request) {
        if (!this.clmConnector.isActive() || !this.clmConnector.isConfigured()) {
            request.getQuarantinedResult().completeExceptionally((Throwable)new ConfigurationException(ViolationError.IQ_SERVER_CONFIGURATION_ERROR.getMessage()));
            return;
        }
        try {
            this.processRequest(request);
        }
        catch (CompatibilityException exception) {
            this.log.debug(exception.getMessage(), (Throwable)exception);
            request.getQuarantinedResult().completeExceptionally(exception);
        }
        catch (Exception exception) {
            this.log.error("Failed retrieving quarantine audit from remote", (Throwable)exception);
            request.getQuarantinedResult().completeExceptionally(new InternalException(ViolationError.INTERNAL_ERROR.getMessage()));
        }
    }

    private void processRequest(QuarantinedComponentVersionsRequest request) throws CompatibilityException, InternalException {
        ClmService clmService = (ClmService)this.clmServiceProvider.get();
        clmService.validateConfiguration();
        List<String> paths = request.getRepositoryComponents().stream().map(AuditRepositoryComponent::getPathname).collect(Collectors.toList());
        Stopwatch sw = Stopwatch.createStarted();
        List<FirewallComponentVersionsApi.RepositoryPathVersions> componentsVersionsByPath = this.firewallComponentVersionsApi.getComponentVersions((ClmService)((ClmService)this.clmServiceProvider.get()), (String)this.deploymentAccess.getId(), (String)request.getRepositoryName(), paths).pathVersions;
        this.log.debug("Retrieved {} quarantined paths for {} repository in {}", new Object[]{request.getRepositoryComponents().size(), request.getRepositoryName(), sw.stop()});
        ArrayList repositoryComponents = new ArrayList(request.getRepositoryComponents());
        QuarantinedComponentVersions quarantinedComponentVersions = new QuarantinedComponentVersions();
        for (FirewallComponentVersionsApi.RepositoryPathVersions pathVersions : componentsVersionsByPath) {
            AuditRepositoryComponent auditRepositoryComponent = (AuditRepositoryComponent)repositoryComponents.get(pathVersions.requestIndex);
            pathVersions.repositoryComponentPaths.stream().filter(FirewallComponentVersionsApi.RepositoryComponentPath::isQuarantine).forEach(pathStatus -> quarantinedComponentVersions.addRepositoryVersion(auditRepositoryComponent, pathStatus.getPathname()));
        }
        request.getQuarantinedResult().complete(quarantinedComponentVersions);
    }
}

