/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentDetailService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentVersionsService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.firewall.event.ComponentDetailsRequest;
import org.sonatype.nexus.repository.firewall.event.QuarantineComponentsRequestEvent;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

@Named
@Singleton
public class FirewallComponentDetailsListener
extends ComponentSupport
implements EventAware {
    private final ComponentDetailService componentDetailService;
    private final ComponentVersionsService componentVersionsService;
    private final Provider<ClmService> clmServiceProvider;
    private final RestClientProvider restClientProvider;
    private final Semaphore semaphore;
    private final AtomicLong waitingRequestCount = new AtomicLong();
    private final AtomicInteger inProgressRequestCount = new AtomicInteger();
    private long lastRequestLogTime = 0L;

    @Inject
    public FirewallComponentDetailsListener(ComponentDetailService componentDetailService, ComponentVersionsService componentVersionsService, Provider<ClmService> clmServiceProvider, RestClientProvider restClientProvider, @Named(value="${nexus.firewall.request.limit:-100}") @Named(value="${nexus.firewall.request.limit:-100}") int requestLimit) {
        this.componentDetailService = componentDetailService;
        this.componentVersionsService = componentVersionsService;
        this.clmServiceProvider = clmServiceProvider;
        this.restClientProvider = restClientProvider;
        this.log.debug("FirewallComponentDetailsListener instantiated with request limit of {}", (Object)requestLimit);
        this.semaphore = new Semaphore(requestLimit, true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentDetailsRequest request) {
        try {
            try {
                this.log.trace("Acquiring permit for ComponentDetailsRequest");
                this.acquireSemaphore();
                Map<String, Date> catalogDates = this.componentDetailService.getCatalogDates((ClmService)this.clmServiceProvider.get(), request.getPackageUrls());
                this.log.trace("Catalog dates for component {} versions => {}", (Object)request.getName(), catalogDates);
                request.getResult().complete(catalogDates);
            }
            catch (InterruptedException | InternalException e) {
                this.log.error("Error getting component details for '{}'", (Object)request.getName(), (Object)e);
                request.getResult().completeExceptionally(e);
                this.releaseSemaphore();
            }
        }
        finally {
            this.releaseSemaphore();
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(QuarantineComponentsRequestEvent request) {
        try {
            try {
                this.log.trace("Acquiring permit for QuarantineComponentsRequest");
                this.acquireSemaphore();
                RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(request.getRepository().getFormat(), request.getComponents(), "reevaluation");
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Evaluating component metadata for {}", request.getComponents().stream().map(QuarantineComponentsRequestEvent.FirewallComponent::getPath).collect(Collectors.toList()));
                }
                RepositoryComponentEvaluationDataList result = this.restClientProvider.getRepositoryClient(request.getRepository().getName()).evaluateComponentMetadata(requestList);
                request.getResult().complete(this.filterQuarantined(requestList, result));
            }
            catch (IOException | InterruptedException e) {
                this.log.error("Error evaluating component metadata for {} {}", request.getComponents().stream().map(QuarantineComponentsRequestEvent.FirewallComponent::getPath).collect(Collectors.toList()), (Object)e.getMessage());
                request.getResult().completeExceptionally(e);
                this.releaseSemaphore();
            }
        }
        finally {
            this.releaseSemaphore();
        }
    }

    private RepositoryComponentEvaluationDataRequestList newRequestList(Format format, List<QuarantineComponentsRequestEvent.FirewallComponent> components, String cause) {
        RepositoryComponentEvaluationDataRequestList requestList = new RepositoryComponentEvaluationDataRequestList(cause);
        for (QuarantineComponentsRequestEvent.FirewallComponent component : components) {
            requestList.components.add(new RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest(format.getValue(), component.getPath(), component.getHash()));
        }
        return requestList;
    }

    private List<String> filterQuarantined(RepositoryComponentEvaluationDataRequestList requestList, RepositoryComponentEvaluationDataList result) {
        return result.componentEvalResults.stream().filter(data -> data.quarantine).map(data -> ((RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest)repositoryComponentEvaluationDataRequestList.components.get((int)data.requestIndex)).pathname).collect(Collectors.toList());
    }

    @VisibleForTesting
    void acquireSemaphore() throws InterruptedException {
        this.waitingRequestCount.incrementAndGet();
        this.semaphore.acquire();
        this.logRequestQueueTimeLimited(this.inProgressRequestCount.incrementAndGet(), this.waitingRequestCount.decrementAndGet());
    }

    @VisibleForTesting
    void releaseSemaphore() {
        this.semaphore.release();
        this.inProgressRequestCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void logRequestQueueTimeLimited(int currentRequests, long queueLength) {
        long currentTime = System.currentTimeMillis();
        FirewallComponentDetailsListener firewallComponentDetailsListener = this;
        synchronized (firewallComponentDetailsListener) {
            if (this.lastRequestLogTime + 10000L > currentTime) {
                return;
            }
            this.lastRequestLogTime = currentTime;
        }
        this.log.debug("Firewall outbound requests - In Progress: {}, Queue length: {}", (Object)currentRequests, (Object)queueLength);
    }
}

