/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.api;

import com.sonatype.nexus.clm.validator.ClmAuthentication;
import io.swagger.annotations.ApiModelProperty;
import java.util.StringJoiner;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.validation.constraint.UrlString;

@ClmAuthentication
public class IqConnectionXo {
    @ApiModelProperty(value="Whether to use Sonatype Repository Firewall")
    private boolean enabled;
    @ApiModelProperty(value="Show Sonatype Repository Firewall link in Browse menu when server is enabled")
    private boolean showLink;
    @ApiModelProperty(value="The address of your Sonatype Repository Firewall")
    @NotEmpty
    @UrlString
    private String url;
    @ApiModelProperty(value="Authentication method", allowableValues="USER,PKI")
    @NotNull
    private String authenticationType;
    @ApiModelProperty(value="User with access to Sonatype Repository Firewall")
    private String username;
    @ApiModelProperty(value="Credentials for the Sonatype Repository Firewall User")
    private String password;
    @ApiModelProperty(value="Use certificates stored in the Nexus Repository Manager truststore to connect to Sonatype Repository Firewall")
    private boolean useTrustStoreForUrl;
    @ApiModelProperty(value="Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.")
    @Min(value=1L)
    @Max(value=3600L)
    private @Min(value=1L) @Max(value=3600L) Integer timeoutSeconds;
    @ApiModelProperty(value="Additional properties to configure for Sonatype Repository Firewall")
    private String properties;
    @ApiModelProperty(value="Allow by default when quarantine is enabled and the IQ connection fails")
    private boolean failOpenModeEnabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseTrustStoreForUrl() {
        return this.useTrustStoreForUrl;
    }

    public void setUseTrustStoreForUrl(boolean useTrustStoreForUrl) {
        this.useTrustStoreForUrl = useTrustStoreForUrl;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public boolean isFailOpenModeEnabled() {
        return this.failOpenModeEnabled;
    }

    public void setFailOpenModeEnabled(boolean failOpenModeEnabled) {
        this.failOpenModeEnabled = failOpenModeEnabled;
    }

    public String toString() {
        return new StringJoiner(", ", String.valueOf(IqConnectionXo.class.getSimpleName()) + "[", "]").add("enabled=" + this.enabled).add("showLink=" + this.showLink).add("url='" + this.url + "'").add("authenticationType='" + this.authenticationType + "'").add("username='" + this.username + "'").add("password='" + this.password + "'").add("useTrustStoreForUrl=" + this.useTrustStoreForUrl).add("timeoutSeconds=" + this.timeoutSeconds).add("properties='" + this.properties + "'").add("failOpenModeEnabled=" + this.failOpenModeEnabled).toString();
    }
}

