/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sonatype.insight.client.utils.HttpClientUtils;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.nexus.clm.ClmAuthenticationType;
import com.sonatype.nexus.clm.ClmConfiguration;
import com.sonatype.nexus.clm.internal.capability.ClmCapability;
import com.sonatype.nexus.clm.internal.capability.ClmCapabilityDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.PreemptiveAuthHttpRequestInterceptor;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
@Singleton
public class ClmConnector
extends ComponentSupport {
    private static final String FEATURES_URI = "/rest/product/features";
    private static final String FEATURES_FIREWALL = "firewall";
    private static final String FEATURES_KEY = "features";
    private final CapabilityRegistry capabilityRegistry;
    private final HttpClientManager httpClientManager;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Cache<String, List<String>> featuresCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();

    @Inject
    public ClmConnector(CapabilityRegistry capabilityRegistry, HttpClientManager httpClientManager) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
    }

    @Nullable
    public ClmConfiguration getConfiguration() {
        return this.getClmCapabilityReference().map(capabilityReference -> (ClmConfiguration)((Object)((Object)((ClmCapability)capabilityReference.capabilityAs(ClmCapability.class)).getConfig()))).orElse(null);
    }

    public boolean isConfigured() {
        return this.getConfiguration() != null;
    }

    public boolean isActive() {
        return this.getClmCapabilityReference().map(capabilityReference -> capabilityReference.context().isActive()).orElse(false);
    }

    public boolean isEnabled() {
        return this.getClmCapabilityReference().map(capabilityReference -> capabilityReference.context().isEnabled()).orElse(false);
    }

    public boolean isFailOpenModeEnabled() {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(ClmCapabilityDescriptor.TYPE).includeNotExposed()).stream().findFirst().map(capabilityReference -> ((ClmConfiguration)((Object)((Object)((ClmCapability)capabilityReference.capabilityAs(ClmCapability.class)).getConfig()))).isFailOpenModeEnabled()).orElse(false);
    }

    public ClmConnector configure(ClmConfiguration configuration, @Nullable Boolean enabled) {
        Optional<CapabilityReference> capabilityReference = this.getClmCapabilityReference();
        if (capabilityReference.isPresent()) {
            CapabilityReference reference = capabilityReference.get();
            this.capabilityRegistry.update(reference.context().id(), enabled != null ? enabled.booleanValue() : reference.context().isEnabled(), reference.context().notes(), configuration.asMap());
        } else {
            this.capabilityRegistry.add(ClmCapabilityDescriptor.TYPE, enabled != null ? enabled : true, null, configuration.asMap());
        }
        return this;
    }

    private Optional<CapabilityReference> getClmCapabilityReference() {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(ClmCapabilityDescriptor.TYPE).includeNotExposed()).stream().findFirst();
    }

    public RestClientConfiguration getRestConfiguration() {
        ClmConfiguration config = this.getConfiguration();
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"IQ Server has not been configured");
        if (ClmAuthenticationType.PKI == config.getAuthenticationType()) {
            return this.getRestConfiguration(config.getUrl(), config.getUseTrustStore(), config.getTimeout());
        }
        return this.getRestConfiguration(config.getUrl(), config.getUseTrustStore(), config.getTimeout(), config.getUsername(), config.getPassword());
    }

    public HttpClientUtils.Configuration getHttpClientUtilsConfiguration() {
        ClmConfiguration config = this.getConfiguration();
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"IQ Server has not been configured");
        if (ClmAuthenticationType.PKI == config.getAuthenticationType()) {
            return this.getHttpClientUtilsConfiguration(config.getUrl(), config.getUseTrustStore(), config.getTimeout());
        }
        return this.getHttpClientUtilsConfiguration(config.getUrl(), config.getUseTrustStore(), config.getTimeout(), config.getUsername(), config.getPassword());
    }

    public RestClientConfiguration getRestConfiguration(String url, boolean useTrustStore, Integer timeout) {
        return this.getRestConfiguration(url, useTrustStore, timeout, null, null);
    }

    public RestClientConfiguration getRestConfiguration(String url, boolean useTrustStore, Integer timeout, String username, String password) {
        RestClientConfiguration result = new RestClientConfiguration();
        result.setServerUrl(url);
        result.setHttpClientProvider(this.getHttpClientProvider(useTrustStore, timeout, username, password));
        return result;
    }

    public HttpClientUtils.Configuration getHttpClientUtilsConfiguration(String url, boolean useTrustStore, Integer timeout) {
        return this.getHttpClientUtilsConfiguration(url, useTrustStore, timeout, null, null);
    }

    public HttpClientUtils.Configuration getHttpClientUtilsConfiguration(String url, boolean useTrustStore, Integer timeout, String username, String password) {
        HttpClientUtils.Configuration config = new HttpClientUtils.Configuration();
        config.setServerUrl(url);
        config.setHttpClientProvider(c -> this.createHttpClientBuilder(useTrustStore, timeout, username, password));
        return config;
    }

    RestClientConfiguration.HttpClientProvider getHttpClientProvider(boolean useTrustStore, Integer timeout, String username, String password) {
        return restClientConfiguration -> this.createHttpClientBuilder(useTrustStore, timeout, username, password);
    }

    public HttpClientBuilder createHttpClientBuilder(boolean useTrustStore, Integer timeout, String username, String password) {
        HttpClientConfiguration configuration = this.httpClientManager.newConfiguration();
        if (username != null) {
            UsernameAuthenticationConfiguration authentication = new UsernameAuthenticationConfiguration();
            authentication.setUsername(username);
            authentication.setPassword(password);
            configuration.setAuthentication((AuthenticationConfiguration)authentication);
        }
        ConnectionConfiguration connection = new ConnectionConfiguration();
        configuration.setConnection(connection);
        connection.setUseTrustStore(Boolean.valueOf(useTrustStore));
        connection.setEnableCookies(Boolean.valueOf(true));
        if (timeout != null) {
            connection.setTimeout(Time.seconds((long)timeout.intValue()));
        }
        return this.httpClientManager.prepare((HttpClientPlan.Customizer)new ConfigurationCustomizer(configuration){

            public void customize(HttpClientPlan plan) {
                super.customize(plan);
                plan.getClient().useSystemProperties();
                plan.getClient().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor());
            }
        });
    }

    public HttpClientBuilder createHttpClientBuilder() {
        ClmConfiguration config = this.getConfiguration();
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"IQ Server has not been configured");
        return this.createHttpClientBuilder(config.getUseTrustStore(), config.getTimeout(), config.getUsername(), config.getPassword());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<List<String>> getClmFeatures(String url) throws IOException {
        List cachedFeatures = (List)featuresCache.getIfPresent((Object)FEATURES_KEY);
        if (cachedFeatures != null) return Optional.ofNullable(cachedFeatures);
        String endPoint = String.format("%s%s", StringUtils.strip((String)url, (String)"/"), FEATURES_URI);
        HttpGet httpGet = new HttpGet(endPoint);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            CloseableHttpClient client = this.createHttpClientBuilder().build();
            try {
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String responseBody = EntityUtils.toString((HttpEntity)entity);
                        cachedFeatures = (List)this.objectMapper.readValue(responseBody, List.class);
                        featuresCache.put((Object)FEATURES_KEY, (Object)cachedFeatures);
                    }
                }
                if (client == null) return Optional.ofNullable(cachedFeatures);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (client == null) throw throwable;
                client.close();
                throw throwable;
            }
            client.close();
            return Optional.ofNullable(cachedFeatures);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public boolean getHasFirewall() {
        List<String> features;
        ClmConfiguration clmConfiguration = this.getConfiguration();
        if (clmConfiguration == null || !this.isEnabled()) {
            return false;
        }
        try {
            features = this.getClmFeatures(clmConfiguration.getUrl()).orElse(Collections.emptyList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.checkForFirewallMatch(features);
    }

    private boolean checkForFirewallMatch(List<String> features) {
        return features.stream().map(String::toLowerCase).anyMatch(FEATURES_FIREWALL::equalsIgnoreCase);
    }
}

