/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.h2.tools.Server;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class H2WebConsole
extends StateGuardLifecycleSupport
implements EventAware,
EventAware.Asynchronous {
    private final File databasesDir;
    private final boolean httpListenerEnabled;
    private final int httpListenerPort;
    private Server h2Server;

    @Inject
    public H2WebConsole(ApplicationDirectories applicationDirectories, @Named(value="${nexus.h2.httpListenerEnabled:-false}") @Named(value="${nexus.h2.httpListenerEnabled:-false}") boolean httpListenerEnabled, @Named(value="${nexus.h2.httpListenerPort:-8082}") @Named(value="${nexus.h2.httpListenerPort:-8082}") int httpListenerPort, NodeAccess nodeAccess) {
        Preconditions.checkNotNull((Object)applicationDirectories);
        this.httpListenerEnabled = httpListenerEnabled;
        this.httpListenerPort = httpListenerPort;
        this.databasesDir = applicationDirectories.getWorkDirectory("db");
    }

    protected void doStart() throws Exception {
        if (this.httpListenerEnabled) {
            this.h2Server = Server.createWebServer((String[])new String[]{"-webPort", String.valueOf(this.httpListenerPort), "-webAllowOthers", "-ifExists", "-baseDir", this.databasesDir.toString()}).start();
            this.log.info("Activated");
        }
    }

    protected void doStop() throws Exception {
        if (this.h2Server != null) {
            this.h2Server.shutdown();
            this.h2Server = null;
            this.log.info("Shutdown");
        }
    }

    @Guarded(by={"STARTED"})
    public Server getH2Server() {
        return this.h2Server;
    }
}

