/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis.handlers;

import com.google.common.collect.Iterables;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class TokenizingTypeHandler
extends BaseTypeHandler<Collection<String>> {
    private static final String SEPARATOR = " ";

    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, Collection<String> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, TokenizingTypeHandler.tokenize(TokenizingTypeHandler.toString(parameter)));
    }

    private static String tokenize(String token) {
        return token.replaceAll("[.-/]", SEPARATOR);
    }

    private static String toString(Collection<String> values) {
        if (values.isEmpty()) {
            return "";
        }
        if (values.size() == 1) {
            return (String)Iterables.getOnlyElement(values);
        }
        return values.stream().collect(Collectors.joining(SEPARATOR));
    }

    public Collection<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

