/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis.handlers;

import com.google.common.base.Preconditions;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.sonatype.nexus.security.PasswordHelper;

public class PasswordCharacterArrayTypeHandler
extends BaseTypeHandler<char[]> {
    private final PasswordHelper passwordHelper;

    public PasswordCharacterArrayTypeHandler(PasswordHelper passwordHelper) {
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, char[] parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, this.passwordHelper.encryptChars(parameter));
    }

    public char[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.passwordHelper.decryptChars(rs.getString(columnName));
    }

    public char[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.passwordHelper.decryptChars(rs.getString(columnIndex));
    }

    public char[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.passwordHelper.decryptChars(cs.getString(columnIndex));
    }
}

