/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis.handlers;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.annotation.Nullable;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateTimeTypeHandler
extends BaseTypeHandler<DateTime> {
    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, DateTime parameter, JdbcType jdbcType) throws SQLException {
        ps.setTimestamp(parameterIndex, new Timestamp(parameter.getMillis()));
    }

    public DateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.nullableDateTime(rs.getTimestamp(columnName));
    }

    public DateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.nullableDateTime(rs.getTimestamp(columnIndex));
    }

    public DateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.nullableDateTime(cs.getTimestamp(columnIndex));
    }

    @Nullable
    private DateTime nullableDateTime(@Nullable Timestamp timestamp) {
        return timestamp != null ? new DateTime(timestamp.getTime(), DateTimeZone.UTC) : null;
    }
}

