/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonatype.nexus.datastore.mybatis.SensitiveJsonGenerator;
import org.sonatype.nexus.datastore.mybatis.SensitiveJsonParser;
import org.sonatype.nexus.security.PasswordHelper;

final class SensitiveJsonFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient PasswordHelper passwordHelper = null;
    private transient Predicate<String> attributeFilter = Predicates.alwaysFalse();

    SensitiveJsonFactory() {
    }

    void encryptSensitiveFields(PasswordHelper passwordHelper, Predicate<String> attributeFilter) {
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.attributeFilter = (Predicate)Preconditions.checkNotNull(attributeFilter);
    }

    public JsonGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        JsonGenerator generator = super.createGenerator(out, enc);
        if (this.passwordHelper != null) {
            return new SensitiveJsonGenerator(generator, this.passwordHelper, this.attributeFilter);
        }
        return generator;
    }

    public JsonParser createParser(byte[] data) throws IOException {
        JsonParser parser = super.createParser(data);
        if (this.passwordHelper != null) {
            return new SensitiveJsonParser(parser, this.passwordHelper, this.attributeFilter);
        }
        return parser;
    }

    public JsonFactory copy() {
        return new SensitiveJsonFactory();
    }
}

