/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum PlaceholderTypes {
    UUID_TYPE((Map<String, String>)ImmutableMap.of((Object)"H2", (Object)"UUID", (Object)"PostgreSQL", (Object)"UUID")),
    JSON_TYPE((Map<String, String>)ImmutableMap.of((Object)"H2", (Object)"JSON", (Object)"PostgreSQL", (Object)"JSONB")),
    BINARY_TYPE((Map<String, String>)ImmutableMap.of((Object)"H2", (Object)"BYTEA", (Object)"PostgreSQL", (Object)"BYTEA"));

    private static final Logger log;
    private static final Pattern TYPE_PATTERN;
    private final Map<String, String> defaults;

    static {
        log = LoggerFactory.getLogger(PlaceholderTypes.class);
        TYPE_PATTERN = Pattern.compile("[A-Za-z]+(?: [A-Za-z]+)?(?: ?\\([1-9][0-9]*\\))?");
    }

    private PlaceholderTypes(Map<String, String> defaults) {
        this.defaults = (Map)Preconditions.checkNotNull(defaults);
    }

    public static boolean configurePlaceholderTypes(Configuration config) {
        String databaseId = config.getDatabaseId();
        Properties variables = config.getVariables();
        boolean lenient = false;
        PlaceholderTypes[] placeholderTypesArray = PlaceholderTypes.values();
        int n = placeholderTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlaceholderTypes placeholder = placeholderTypesArray[n2];
            String name = placeholder.name();
            String key = String.valueOf(name) + '.' + databaseId;
            String type = placeholder.defaults.get(databaseId);
            if (type == null) {
                type = variables.getProperty(key);
                lenient = true;
            }
            if (Strings.isNullOrEmpty((String)type)) {
                log.warn("No type configured for {}", (Object)key);
                throw new IllegalArgumentException(String.format("No database type configured for %s", key));
            }
            if (!TYPE_PATTERN.matcher(type).matches()) {
                log.warn("Invalid type {} configured for {}", (Object)type, (Object)key);
                throw new IllegalArgumentException(String.format("Invalid database type %s configured for %s", type, key));
            }
            variables.put(name, type);
            ++n2;
        }
        return lenient;
    }
}

