/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.io.Resources;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.OffsetDateTimeTypeHandler;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.h2.jdbc.JdbcSQLNonTransientConnectionException;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityUUID;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.crypto.internal.CryptoHelperImpl;
import org.sonatype.nexus.crypto.internal.MavenCipherImpl;
import org.sonatype.nexus.crypto.maven.MavenCipher;
import org.sonatype.nexus.datastore.DataStoreSupport;
import org.sonatype.nexus.datastore.api.DataAccess;
import org.sonatype.nexus.datastore.api.DataAccessException;
import org.sonatype.nexus.datastore.api.Expects;
import org.sonatype.nexus.datastore.api.SchemaTemplate;
import org.sonatype.nexus.datastore.mybatis.AbstractJsonTypeHandler;
import org.sonatype.nexus.datastore.mybatis.CipherAwareTypeHandler;
import org.sonatype.nexus.datastore.mybatis.ContinuationArrayList;
import org.sonatype.nexus.datastore.mybatis.DataAccessSqlSession;
import org.sonatype.nexus.datastore.mybatis.EntityInterceptor;
import org.sonatype.nexus.datastore.mybatis.FrozenChecker;
import org.sonatype.nexus.datastore.mybatis.H2VersionUpgrader;
import org.sonatype.nexus.datastore.mybatis.MyBatisCipher;
import org.sonatype.nexus.datastore.mybatis.MyBatisDataSession;
import org.sonatype.nexus.datastore.mybatis.PlaceholderTypes;
import org.sonatype.nexus.datastore.mybatis.SensitiveAttributes;
import org.sonatype.nexus.datastore.mybatis.handlers.AttributesTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.DateTimeTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.EncryptedStringTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.EntityUUIDTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.LenientUUIDTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.ListTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.MapTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.NestedAttributesMapTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.PasswordCharacterArrayTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.PrincipalCollectionTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.SetTypeHandler;
import org.sonatype.nexus.datastore.mybatis.handlers.TokenizingTypeHandler;
import org.sonatype.nexus.security.PasswordHelper;
import org.sonatype.nexus.security.PhraseService;
import org.sonatype.nexus.transaction.TransactionIsolation;

@Named(value="jdbc")
public class MyBatisDataStore
extends DataStoreSupport<MyBatisDataSession> {
    private static final String REGISTERED_MESSAGE = "Registered {}";
    public static final String H2_DATABASE = "H2";
    private static final Key<TypeHandler> TYPE_HANDLER_KEY = Key.get(TypeHandler.class);
    private static final TypeHandlerMediator TYPE_HANDLER_MEDIATOR = new TypeHandlerMediator();
    private static final Splitter BY_LINE = Splitter.onPattern((String)"\\r?\\n").trimResults().omitEmptyStrings();
    private static final Splitter KEY_VALUE = Splitter.onPattern((String)"[=:]").limit(2).trimResults().omitEmptyStrings();
    private static final Splitter.MapSplitter TO_MAP = BY_LINE.withKeyValueSeparator(KEY_VALUE);
    private static final Pattern MAPPER_BODY = Pattern.compile(".*<mapper[^>]*>(.*)</mapper>", 32);
    private static final int DEFAULT_CONTENT_STORE_MAX_POOL_SIZE = 100;
    private final Iterable<? extends BeanEntry<Named, Class<DataAccess>>> declaredAccessTypes;
    private final Set<Class<?>> registeredAccessTypes = new HashSet();
    private final AtomicBoolean frozenMarker = new AtomicBoolean();
    private final PbeCipherFactory.PbeCipher databaseCipher;
    private final PasswordHelper passwordHelper;
    private final ApplicationDirectories directories;
    private final BeanLocator beanLocator;
    private final ClassLoader uberClassLoader;
    private HikariDataSource dataSource;
    private Configuration mybatisConfig;
    private H2VersionUpgrader h2VersionUpgrader;
    private Optional<Configuration> previousConfig = Optional.empty();
    @Nullable
    private Predicate<String> sensitiveAttributeFilter;

    @Inject
    public MyBatisDataStore(@Named(value="mybatis") // Could not load outer class - annotation placement on inner may be incorrect
     @Named(value="mybatis") PbeCipherFactory.PbeCipher databaseCipher, @Named(value="nexus-uber") @Named(value="nexus-uber") ClassLoader classLoader, PasswordHelper passwordHelper, ApplicationDirectories directories, BeanLocator beanLocator) {
        Preconditions.checkState((boolean)(databaseCipher instanceof MyBatisCipher));
        this.uberClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.databaseCipher = (PbeCipherFactory.PbeCipher)Preconditions.checkNotNull((Object)databaseCipher);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.useMyBatisClassLoaderForEntityProxies();
        this.declaredAccessTypes = beanLocator.locate((Key)new Key<Class<DataAccess>>(){});
    }

    @VisibleForTesting
    public MyBatisDataStore() {
        try {
            this.databaseCipher = new MyBatisCipher();
            MavenCipherImpl passwordCipher = new MavenCipherImpl((CryptoHelper)new CryptoHelperImpl());
            this.passwordHelper = new PasswordHelper((MavenCipher)passwordCipher, PhraseService.LEGACY_PHRASE_SERVICE);
            this.uberClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error during setup", e);
        }
        this.directories = null;
        this.beanLocator = null;
        this.declaredAccessTypes = ImmutableList.of();
    }

    protected void doStart(String storeName, Map<String, String> attributes) throws Exception {
        HikariConfig hikariConfig = this.configureHikari(storeName, attributes);
        try {
            this.dataSource = new HikariDataSource(hikariConfig);
        }
        catch (Exception exception) {
            if (this.isH2UnsupportedDatabaseVersion(exception)) {
                this.dataSource = this.h2VersionUpgrader.upgradeH2Database(storeName, hikariConfig);
            }
            throw exception;
        }
        Environment environment = new Environment(storeName, (TransactionFactory)new JdbcTransactionFactory(), (DataSource)this.dataSource);
        if (this.previousConfig.isPresent()) {
            this.mybatisConfig = this.previousConfig.get();
            this.mybatisConfig.setEnvironment(environment);
        } else {
            this.mybatisConfig = this.configureMyBatis(environment);
            this.registerCommonTypeHandlers();
            if (this.beanLocator != null) {
                this.beanLocator.watch(TYPE_HANDLER_KEY, (Mediator)TYPE_HANDLER_MEDIATOR, (Object)this);
            }
        }
    }

    protected void doStop() throws Exception {
        this.previousConfig = Optional.ofNullable(this.mybatisConfig);
        this.mybatisConfig = null;
        this.registeredAccessTypes.clear();
        try {
            this.dataSource.close();
        }
        finally {
            this.dataSource = null;
        }
    }

    public void register(Class<? extends DataAccess> accessType) {
        if (!this.registeredAccessTypes.add(accessType) || accessType.isAnnotationPresent(SchemaTemplate.class)) {
            return;
        }
        this.registerSimpleAliases(accessType);
        this.registerDataAccessMapper(accessType);
        this.info("Creating schema for {}", new Object[]{accessType.getSimpleName()});
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataAccessSqlSession session = new DataAccessSqlSession(this.mybatisConfig);){
            DataAccess dao = (DataAccess)session.getMapper(accessType);
            DataAccessException exception = null;
            int tries = 0;
            while (tries < 5) {
                try {
                    dao.createSchema();
                    dao.extendSchema();
                    session.commit();
                    exception = null;
                    break;
                }
                catch (DataAccessException dae) {
                    exception = dae;
                    this.log.debug("Schema creation failed", (Throwable)dae);
                    session.rollback();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.warn("Schema creation thread interrupted, proceeding with creation");
                    }
                    ++tries;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void unregister(Class<? extends DataAccess> accessType) {
    }

    @Guarded(by={"STARTED"})
    public MyBatisDataSession openSession() {
        return new MyBatisDataSession((SqlSession)new DataAccessSqlSession(this.mybatisConfig));
    }

    @Guarded(by={"STARTED"})
    public MyBatisDataSession openSession(TransactionIsolation isolationLevel) {
        switch (isolationLevel) {
            case SERIALIZABLE: {
                return new MyBatisDataSession((SqlSession)new DataAccessSqlSession(this.mybatisConfig, TransactionIsolationLevel.SERIALIZABLE));
            }
        }
        return new MyBatisDataSession((SqlSession)new DataAccessSqlSession(this.mybatisConfig));
    }

    @Guarded(by={"STARTED"})
    public Connection openConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Guarded(by={"STARTED"})
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void freeze() {
        this.frozenMarker.set(true);
    }

    public void unfreeze() {
        this.frozenMarker.set(false);
    }

    public boolean isFrozen() {
        return this.frozenMarker.get();
    }

    @Guarded(by={"STARTED"})
    public void backup(String location) throws SQLException {
        block19: {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Connection conn = this.openConnection();){
                if (H2_DATABASE.equals(conn.getMetaData().getDatabaseProductName())) {
                    Throwable throwable2 = null;
                    Object var6_9 = null;
                    try (PreparedStatement backupStmt = conn.prepareStatement("BACKUP TO ?");){
                        backupStmt.setString(1, location);
                        backupStmt.execute();
                        break block19;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                throw new UnsupportedOperationException("The underlying database is not supported for backup.");
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    @Inject
    public void setH2VersionUpgrader(H2VersionUpgrader h2VersionUpgrader) {
        this.h2VersionUpgrader = (H2VersionUpgrader)((Object)Preconditions.checkNotNull((Object)((Object)h2VersionUpgrader)));
    }

    private HikariConfig configureHikari(String storeName, Map<String, String> attributes) {
        Properties properties = new Properties();
        properties.put("poolName", storeName);
        properties.putAll(attributes);
        Object advanced = properties.remove("advanced");
        if (advanced instanceof String) {
            TO_MAP.split((CharSequence)((String)advanced)).forEach(properties::putIfAbsent);
        }
        if (attributes.get("jdbcUrl").startsWith("jdbc:postgresql")) {
            properties.put("driverClassName", "org.postgresql.Driver");
            properties.put("dataSource.stringtype", "unspecified");
            properties.putIfAbsent("maximumPoolSize", (Object)100);
        }
        if (Strings2.isBlank((String)properties.getProperty("schema"))) {
            properties.remove("schema");
        }
        return new HikariConfig(properties);
    }

    private Configuration configureMyBatis(Environment environment) throws IOException {
        Configuration myBatisConfig = this.loadMyBatisConfiguration(environment);
        String databaseId = new VendorDatabaseIdProvider().getDatabaseId(environment.getDataSource());
        this.info("MyBatis databaseId: {}", new Object[]{databaseId});
        myBatisConfig.setEnvironment(environment);
        myBatisConfig.setDatabaseId(databaseId);
        myBatisConfig.setMapUnderscoreToCamelCase(true);
        myBatisConfig.setReturnInstanceForEmptyRow(true);
        myBatisConfig.setObjectFactory((ObjectFactory)new DefaultObjectFactory(){

            public <T> boolean isCollection(Class<T> type) {
                return Iterable.class.isAssignableFrom(type) || super.isCollection(type);
            }

            protected Class<?> resolveInterface(Class<?> type) {
                if (type == Continuation.class) {
                    return ContinuationArrayList.class;
                }
                return super.resolveInterface(type);
            }
        });
        return myBatisConfig;
    }

    private void registerCommonTypeHandlers() {
        boolean lenient = PlaceholderTypes.configurePlaceholderTypes(this.mybatisConfig);
        this.register((TypeHandler<?>)new ListTypeHandler());
        this.register((TypeHandler<?>)new SetTypeHandler());
        this.register((TypeHandler<?>)new MapTypeHandler());
        this.register((TypeHandler<?>)new DateTimeTypeHandler());
        this.register((TypeHandler<?>)new OffsetDateTimeTypeHandler());
        EntityUUIDTypeHandler entityIdHandler = new EntityUUIDTypeHandler(lenient);
        this.register((Class)EntityUUID.class, (TypeHandler)entityIdHandler);
        this.register((Class)EntityId.class, (TypeHandler)entityIdHandler);
        if (lenient) {
            this.register((TypeHandler<?>)new LenientUUIDTypeHandler());
        }
        this.register(new EntityInterceptor(new FrozenChecker(this.frozenMarker, this.uberClassLoader)));
        this.register((TypeHandler<?>)new PasswordCharacterArrayTypeHandler(this.passwordHelper));
        this.register((TypeHandler<?>)new PrincipalCollectionTypeHandler());
        this.registerDetached((TypeHandler)new EncryptedStringTypeHandler());
        this.registerDetached((TypeHandler)new TokenizingTypeHandler());
        this.sensitiveAttributeFilter = SensitiveAttributes.buildSensitiveAttributeFilter(this.mybatisConfig);
        this.register((TypeHandler<?>)new AttributesTypeHandler());
        this.register((TypeHandler<?>)new NestedAttributesMapTypeHandler());
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    protected Configuration loadMyBatisConfiguration(Environment environment) throws IOException {
        if (this.directories == null) {
            this.info("Using default MyBatis configuration", new Object[0]);
            return new Configuration();
        }
        Path configPath = this.myBatisConfigPath(environment);
        this.info("Loading MyBatis configuration from {}", new Object[]{configPath});
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Configuration configuration;
            TcclBlock block;
            InputStream in;
            block17: {
                block16: {
                    in = Files.newInputStream(configPath, new OpenOption[0]);
                    block = TcclBlock.begin(((Object)((Object)this)).getClass());
                    configuration = new XMLConfigBuilder(in, null, new Properties()).parse();
                    if (block == null) break block16;
                    block.close();
                }
                if (in == null) break block17;
                in.close();
            }
            return configuration;
            {
                catch (Throwable throwable2) {
                    try {
                        if (block != null) {
                            block.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Path myBatisConfigPath(Environment environment) {
        Path fabricPath = this.directories.getConfigDirectory("fabric").toPath();
        Path configPath = fabricPath.resolve(String.valueOf(environment.getId()) + "-store-mybatis.xml");
        if (!Files.exists(configPath, new LinkOption[0])) {
            configPath = fabricPath.resolve("mybatis.xml");
        }
        return configPath;
    }

    private void registerSimpleAliases(Class<? extends DataAccess> accessType) {
        TypeAliasRegistry registry = this.mybatisConfig.getTypeAliasRegistry();
        TypeLiteral resolvedType = TypeLiteral.get(accessType);
        Method[] methodArray = accessType.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            for (TypeLiteral parameterType : resolvedType.getParameterTypes((Member)method)) {
                this.registerSimpleAlias(registry, parameterType.getRawType());
            }
            this.registerSimpleAlias(registry, resolvedType.getReturnType(method).getRawType());
            ++n2;
        }
    }

    private void registerSimpleAlias(TypeAliasRegistry registry, Class<?> clazz) {
        if (!clazz.isPrimitive() && !clazz.getName().startsWith("java.")) {
            try {
                registry.registerAlias(clazz);
            }
            catch (LinkageError | RuntimeException e) {
                this.debug("Unable to register type alias", new Object[]{e});
            }
        }
    }

    private void registerDataAccessMapper(Class<? extends DataAccess> accessType) {
        Class<?> templateType = this.findTemplateType(accessType);
        if (templateType != null) {
            this.registerTemplatedMapper(accessType, templateType);
        } else {
            this.registerSimpleMapper(accessType);
        }
        this.debug(REGISTERED_MESSAGE, new Object[]{accessType.getSimpleName()});
    }

    @Nullable
    private Class<?> findTemplateType(Class<? extends DataAccess> accessType) {
        Class<?>[] classArray = accessType.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> candidate = classArray[n2];
            if (candidate.isAnnotationPresent(SchemaTemplate.class)) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    private void registerSimpleMapper(Class<? extends DataAccess> accessType) {
        Expects expects = accessType.getAnnotation(Expects.class);
        if (expects != null) {
            Arrays.asList(expects.value()).forEach(this::register);
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try (TcclBlock tccl = TcclBlock.begin((ClassLoader)this.uberClassLoader);){
            this.mybatisConfig.addMapper(accessType);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void registerTemplatedMapper(Class<? extends DataAccess> accessType, Class<?> templateType) {
        Expects expects = templateType.getAnnotation(Expects.class);
        if (expects != null) {
            Arrays.asList(expects.value()).forEach(expectedType -> {
                if (expectedType.isAnnotationPresent(SchemaTemplate.class)) {
                    this.register(this.expectedAccessType(accessType, templateType, (Class)expectedType));
                } else {
                    this.register((Class<? extends DataAccess>)expectedType);
                }
            });
        }
        String prefix = this.extractPrefix(accessType.getSimpleName(), templateType.getSimpleName());
        String placeholder = templateType.getAnnotation(SchemaTemplate.class).value();
        String xml = this.loadMapperXml(templateType, true).replace("${namespace}", accessType.getName()).replace("${" + placeholder + '}', prefix);
        String includeXml = this.loadMapperXml(accessType, false);
        Matcher mapperBody = MAPPER_BODY.matcher(includeXml);
        if (mapperBody.find()) {
            xml = xml.replace("</mapper>", String.format("<!-- %s -->%s</mapper>", accessType.getName(), mapperBody.group(1)));
        }
        try {
            this.log.trace(xml);
            XMLMapperBuilder xmlParser = new XMLMapperBuilder((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), this.mybatisConfig, accessType.getName(), this.mybatisConfig.getSqlFragments(), accessType.getName());
            xmlParser.parse();
            if (!this.mybatisConfig.hasMapper(accessType)) {
                this.mybatisConfig.addMapper(accessType);
            }
        }
        catch (RuntimeException e) {
            this.log.warn(xml, (Throwable)e);
            throw e;
        }
    }

    private boolean isH2UnsupportedDatabaseVersion(Exception exception) {
        int unsupportedDatabaseErrorCode = 90048;
        return exception.getCause() instanceof JdbcSQLNonTransientConnectionException && ((JdbcSQLNonTransientConnectionException)exception.getCause()).getErrorCode() == unsupportedDatabaseErrorCode;
    }

    private Class expectedAccessType(Class currentAccessType, Class currentTemplateType, Class expectedTemplateType) {
        String currentTemplateName = currentTemplateType.getSimpleName();
        String expectedTemplateName = expectedTemplateType.getSimpleName();
        String currentAccessName = currentAccessType.getSimpleName();
        String expectedAccessName = currentAccessName.replace(currentTemplateName, expectedTemplateName);
        Class expectedAccessType = this.findRegisteredAccessType(expectedAccessName).orElseGet(() -> this.findDeclaredAccessType(expectedAccessName).orElseThrow(() -> new IllegalArgumentException("Access type " + expectedAccessName + " expected by " + currentAccessType + " is missing")));
        Preconditions.checkArgument((boolean)expectedTemplateType.isAssignableFrom(expectedAccessType), (String)"%s must extend %s", (Object)expectedAccessType, (Object)expectedTemplateType);
        return expectedAccessType;
    }

    private Optional<Class<?>> findRegisteredAccessType(String simpleName) {
        return this.registeredAccessTypes.stream().filter(accessType -> simpleName.equals(accessType.getSimpleName())).findFirst();
    }

    private Optional<? extends Class> findDeclaredAccessType(String simpleName) {
        return Streams.stream(this.declaredAccessTypes).map(BeanEntry::getValue).filter(accessType -> simpleName.equals(accessType.getSimpleName())).findFirst();
    }

    private String extractPrefix(String accessName, String templateName) {
        Preconditions.checkArgument((boolean)accessName.endsWith(templateName), (String)"%s must end with %s", (Object)accessName, (Object)templateName);
        String prefix = Strings2.lower((String)accessName.substring(0, accessName.length() - templateName.length()));
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (String)"%s must add a prefix to %s", (Object)accessName, (Object)templateName);
        return prefix;
    }

    private String mapperXmlPath(Class type) {
        return String.valueOf('/') + type.getName().replace('.', '/') + ".xml";
    }

    private String loadMapperXml(Class type, boolean required) {
        URL resource = type.getResource(this.mapperXmlPath(type));
        Preconditions.checkArgument((!required || resource != null ? 1 : 0) != 0, (String)"XML resource for %s is missing", (Object)type);
        try {
            return resource != null ? Resources.toString((URL)resource, (Charset)StandardCharsets.UTF_8) : "";
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read " + resource, e);
        }
    }

    @VisibleForTesting
    public void register(Interceptor interceptor) {
        this.mybatisConfig.addInterceptor(interceptor);
        this.debug(REGISTERED_MESSAGE, new Object[]{interceptor.getClass().getSimpleName()});
    }

    @VisibleForTesting
    public void register(TypeHandler<?> handler) {
        this.prepare(handler).register(handler);
        this.debug(REGISTERED_MESSAGE, new Object[]{handler.getClass().getSimpleName()});
    }

    private <T> void register(Class<T> type, TypeHandler<? extends T> handler) {
        this.prepare(handler).register(type, handler);
        this.debug(REGISTERED_MESSAGE, new Object[]{String.valueOf(handler.getClass().getSimpleName()) + " (" + type.getSimpleName() + ")"});
    }

    private <T> void registerDetached(TypeHandler<? extends T> handler) {
        this.prepare(handler).register(null, null, handler);
        this.debug(REGISTERED_MESSAGE, new Object[]{String.valueOf(handler.getClass().getSimpleName()) + " (detached)"});
    }

    private TypeHandlerRegistry prepare(TypeHandler<?> handler) {
        if (handler instanceof CipherAwareTypeHandler) {
            ((CipherAwareTypeHandler)handler).setCipher(this.databaseCipher);
        }
        if (this.sensitiveAttributeFilter != null && handler instanceof AbstractJsonTypeHandler) {
            ((AbstractJsonTypeHandler)handler).encryptSensitiveFields(this.passwordHelper, this.sensitiveAttributeFilter);
        }
        this.registerSimpleAlias(this.mybatisConfig.getTypeAliasRegistry(), handler.getClass());
        Type handledType = ((BaseTypeHandler)handler).getRawType();
        if (handledType instanceof Class) {
            this.registerSimpleAlias(this.mybatisConfig.getTypeAliasRegistry(), (Class)handledType);
        }
        return this.mybatisConfig.getTypeHandlerRegistry();
    }

    private void useMyBatisClassLoaderForEntityProxies() {
        try {
            ClassLoader myBatisLoader = Configuration.class.getClassLoader();
            String proxyFactoryName = "org.apache.ibatis.javassist.util.proxy.ProxyFactory";
            Class<?> proxyFactoryClass = myBatisLoader.loadClass(proxyFactoryName);
            String classLoaderProviderName = String.valueOf(proxyFactoryName) + "$ClassLoaderProvider";
            Class[] classLoaderProviderApi = new Class[]{myBatisLoader.loadClass(classLoaderProviderName)};
            Field classLoaderProviderField = proxyFactoryClass.getField("classLoaderProvider");
            classLoaderProviderField.set(null, Proxy.newProxyInstance(myBatisLoader, classLoaderProviderApi, (proxy, method, args) -> myBatisLoader));
        }
        catch (Exception | LinkageError e) {
            this.log.warn("Problem applying MyBatis proxy workaround", e);
        }
    }

    static class TypeHandlerMediator
    implements Mediator<Named, TypeHandler, MyBatisDataStore> {
        TypeHandlerMediator() {
        }

        public void add(BeanEntry<Named, TypeHandler> entry, MyBatisDataStore store) {
            store.register((TypeHandler)entry.getValue());
        }

        public void remove(BeanEntry<Named, TypeHandler> entry, MyBatisDataStore store) {
        }
    }
}

