/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.sonatype.nexus.datastore.api.DataAccess;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.TransactionSupport;

public final class MyBatisDataSession
extends TransactionSupport
implements DataSession<Transaction> {
    private final SqlSession session;
    private Actions actions = new Actions();

    public MyBatisDataSession(SqlSession session) {
        this.session = (SqlSession)Preconditions.checkNotNull((Object)session);
    }

    public <D extends DataAccess> D access(Class<D> type) {
        return (D)((DataAccess)this.session.getMapper(type));
    }

    public Transaction getTransaction() {
        return this;
    }

    public void preCommit(Runnable hook) {
        this.actions.preCommit = this.addHook(this.actions.preCommit, hook);
    }

    public void postCommit(Runnable hook) {
        this.actions.postCommit = this.addHook(this.actions.postCommit, hook);
    }

    public void onRollback(Runnable hook) {
        this.actions.onRollback = this.addHook(this.actions.onRollback, hook);
    }

    public String sqlDialect() {
        return this.session.getConfiguration().getDatabaseId();
    }

    protected void doCommit() {
        this.callHooks(this.actions.preCommit);
        this.session.commit();
        this.callHooks(this.actions.postCommit);
    }

    protected void doRollback() {
        this.session.rollback();
        this.callHooks(this.actions.onRollback);
    }

    public boolean allowRetry(Exception cause) {
        boolean retry = super.allowRetry(cause);
        if (retry) {
            this.clearHooks();
        }
        return retry;
    }

    public void close() {
        this.clearHooks();
        this.session.close();
    }

    private Object addHook(Object hooks, Runnable hook) {
        if (hooks == null) {
            return hook;
        }
        if (hooks instanceof Runnable) {
            return Lists.newArrayList((Object[])new Object[]{hooks, hook});
        }
        ((List)hooks).add(hook);
        return hooks;
    }

    private void callHooks(Object hooks) {
        if (hooks == null) {
            return;
        }
        Actions existing = this.actions;
        try {
            this.actions = new Actions();
            if (hooks instanceof Runnable) {
                ((Runnable)hooks).run();
            } else {
                ((List)hooks).forEach(Runnable::run);
            }
        }
        finally {
            this.actions = existing;
        }
    }

    private void clearHooks() {
        this.actions.preCommit = null;
        this.actions.postCommit = null;
        this.actions.onRollback = null;
    }

    private static class Actions {
        Object preCommit;
        Object postCommit;
        Object onRollback;

        private Actions() {
        }
    }
}

