/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.common.io.FileFinder;
import org.sonatype.nexus.common.io.ZipSupport;

@Named
@Singleton
public class H2VersionUpgrader
extends ComponentSupport {
    private final ApplicationDirectories directories;
    private final ManagedLifecycleManager managedLifecycleManager;
    private final String TIMESTAMP_FORMAT = "%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS";
    private final String ZIP_FILE_NAME = "nexus-" + String.format("%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS", LocalDateTime.now()) + "-backup.zip";

    @Inject
    public H2VersionUpgrader(ApplicationDirectories directories, ManagedLifecycleManager managedLifecycleManager) {
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        this.managedLifecycleManager = (ManagedLifecycleManager)Preconditions.checkNotNull((Object)managedLifecycleManager);
    }

    public HikariDataSource upgradeH2Database(String storeName, HikariConfig hikariConfig) throws Exception {
        HikariDataSource dataSource = null;
        this.log.info("Upgrade H2 database from V1.4 to V2.2 starts");
        Path dbPath = this.directories.getWorkDirectory("db").toPath();
        Optional sqlLatestFile = FileFinder.findLatestTimestampedFile((Path)dbPath, (String)"nexus-", (String)".sql");
        if (this.validateH2SqlFileExists(sqlLatestFile)) {
            this.backupCurrentH2Database(dbPath, storeName);
            dataSource = this.createUpgradedH2Database(hikariConfig, ((Path)sqlLatestFile.get()).toString());
        }
        this.log.info("Upgrade H2 database from V1.4 to V2.2 ends");
        return dataSource;
    }

    private boolean validateH2SqlFileExists(Optional<Path> sqlFile) throws Exception {
        if (!sqlFile.isPresent()) {
            StringBuilder buf = new StringBuilder();
            buf.append("\n-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n\n");
            buf.append("Your H2 database version is no longer supported. Upgrade to a supported version using upgrade instructions at https://links.sonatype.com/products/nxrm3/docs/upgrade-h2.html.");
            buf.append("\n\n-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n\n");
            this.log.error(buf.toString());
            this.managedLifecycleManager.shutdownWithExitCode(1);
            return false;
        }
        return true;
    }

    private void backupCurrentH2Database(Path dbPath, String storeName) throws Exception {
        this.log.info("H2 database V1.4 backup starts");
        String dbFileName = String.valueOf(storeName) + ".mv.db";
        String dbTraceFileName = String.valueOf(storeName) + ".trace.db";
        List<String> filesToZip = Arrays.asList(dbFileName, dbTraceFileName);
        String zipPath = dbPath + "/" + this.ZIP_FILE_NAME;
        ZipSupport.zipFiles((Path)dbPath, filesToZip, (String)zipPath);
        this.deleteFile(dbPath.resolve(dbFileName));
        this.deleteFile(dbPath.resolve(dbTraceFileName));
        this.log.info("H2 database V1.4 backup ends, file created: " + zipPath);
    }

    private HikariDataSource createUpgradedH2Database(HikariConfig hikariConfig, String sqlFilePath) throws Exception {
        this.log.info("Create H2 database V2.2 starts");
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection conn = dataSource.getConnection();){
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (PreparedStatement scriptStmt = conn.prepareStatement("RUNSCRIPT FROM '" + sqlFilePath + "' FROM_1X");){
                scriptStmt.execute();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.log.info("Create H2 database V2.2 ends");
        return dataSource;
    }

    private void deleteFile(Path tempFile) throws Exception {
        if (Files.exists(tempFile, new LinkOption[0]) && !Files.isDirectory(tempFile, new LinkOption[0])) {
            Files.deleteIfExists(tempFile);
        }
    }
}

