/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.datastore.api.FreezeImmuneDAO;

class FrozenChecker
extends ComponentSupport {
    private final AtomicBoolean frozenMarker;
    private final ClassLoader classLoader;
    private final ConcurrentMap<String, Boolean> freezeImmuneCache = new ConcurrentHashMap<String, Boolean>();

    public FrozenChecker(AtomicBoolean frozenMarker, @Named(value="nexus-uber") @Named(value="nexus-uber") ClassLoader classLoader) {
        this.frozenMarker = (AtomicBoolean)Preconditions.checkNotNull((Object)frozenMarker);
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
    }

    void checkFrozen(MappedStatement ms) {
        SqlCommandType commandType = ms.getSqlCommandType();
        if (commandType != SqlCommandType.SELECT && this.frozenMarker.get() && !this.isFreezeImmune(ms)) {
            this.log.debug("Disallowing {} because the application is frozen", (Object)commandType);
            throw new FrozenException(commandType + " is not allowed while the application is frozen");
        }
    }

    private boolean isFreezeImmune(MappedStatement ms) {
        return this.freezeImmuneCache.computeIfAbsent(FrozenChecker.toKey(ms.getId()), this::isFreezeImmune);
    }

    private Boolean isFreezeImmune(String className) {
        try {
            Class<?> dao = this.classLoader.loadClass(className);
            return FreezeImmuneDAO.class.isAssignableFrom(dao);
        }
        catch (ClassNotFoundException e) {
            this.log.debug("Unable to locate DAO {}", (Object)className, (Object)e);
            return false;
        }
    }

    private static String toKey(String statementId) {
        int lastPeriod = statementId.lastIndexOf(46);
        if (lastPeriod > 0) {
            return statementId.substring(0, lastPeriod);
        }
        return statementId;
    }
}

