/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.datastore.api.DataAccessException;

final class DataAccessSqlSession
extends DefaultSqlSession {
    public DataAccessSqlSession(Configuration configuration) {
        this(configuration, null);
    }

    public DataAccessSqlSession(Configuration configuration, TransactionIsolationLevel isolationLevel) {
        super(configuration, DataAccessSqlSession.newExecutor(configuration, isolationLevel));
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        try {
            super.select(statement, parameter, rowBounds, handler);
        }
        catch (PersistenceException e) {
            throw DataAccessSqlSession.unwrapMyBatisException(e);
        }
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        try {
            return super.selectList(statement, parameter, rowBounds);
        }
        catch (PersistenceException e) {
            throw DataAccessSqlSession.unwrapMyBatisException(e);
        }
    }

    public int update(String statement, Object parameter) {
        try {
            return super.update(statement, parameter);
        }
        catch (PersistenceException e) {
            throw DataAccessSqlSession.unwrapMyBatisException(e);
        }
    }

    public void commit(boolean force) {
        try {
            super.commit(force);
        }
        catch (PersistenceException e) {
            throw DataAccessSqlSession.unwrapMyBatisException(e);
        }
    }

    public void rollback(boolean force) {
        try {
            super.rollback(force);
        }
        catch (PersistenceException e) {
            throw DataAccessSqlSession.unwrapMyBatisException(e);
        }
    }

    private static RuntimeException unwrapMyBatisException(PersistenceException e) {
        Throwable cause = e.getCause();
        if (cause instanceof DataAccessException) {
            return (DataAccessException)cause;
        }
        if (cause instanceof FrozenException) {
            return (FrozenException)cause;
        }
        return new DataAccessException(e.getMessage(), cause);
    }

    private static Executor newExecutor(Configuration configuration, @Nullable TransactionIsolationLevel isolationLevel) {
        Transaction tx = null;
        try {
            Environment environment = configuration.getEnvironment();
            TransactionFactory txFactory = environment.getTransactionFactory();
            tx = txFactory.newTransaction(environment.getDataSource(), isolationLevel, false);
            Executor executor = configuration.newExecutor(tx);
            return executor;
        }
        catch (Exception e) {
            DataAccessSqlSession.closeQuietly(tx);
            ErrorContext context = ErrorContext.instance().message("Could not connect to database").cause((Throwable)e);
            throw new DataAccessException(context.toString(), (Throwable)e);
        }
        finally {
            ErrorContext.instance().reset();
        }
    }

    private static void closeQuietly(Transaction tx) {
        if (tx != null) {
            try {
                tx.close();
            }
            catch (Exception exception) {}
        }
    }
}

