/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.io.ObjectInputStreamWithClassLoader;
import org.sonatype.nexus.datastore.mybatis.CipherAwareTypeHandler;

public abstract class AbstractSerializableTypeHandler<T>
extends CipherAwareTypeHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSerializableTypeHandler.class);
    private final ObjectInputStreamWithClassLoader.LoadingFunction classLoading;

    protected AbstractSerializableTypeHandler() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        this.classLoading = name -> {
            try {
                return Class.forName(name, false, loader);
            }
            catch (Exception | LinkageError e) {
                log.debug("Handler cannot see serialized type, trying thread context loader...", e);
                return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            }
        };
    }

    protected AbstractSerializableTypeHandler(ObjectInputStreamWithClassLoader.LoadingFunction classLoading) {
        this.classLoading = (ObjectInputStreamWithClassLoader.LoadingFunction)Preconditions.checkNotNull((Object)classLoading);
    }

    public final void setNonNullParameter(PreparedStatement ps, int parameterIndex, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setBytes(parameterIndex, this.serialize(parameter));
    }

    public final T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.deserialize(rs.getBytes(columnName));
    }

    public final T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.deserialize(rs.getBytes(columnIndex));
    }

    public final T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.deserialize(cs.getBytes(columnIndex));
    }

    /*
     * Loose catch block
     */
    private byte[] serialize(T object) throws SQLException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                byte[] byArray;
                ObjectOutputStream out;
                ByteArrayOutputStream buf;
                block18: {
                    block17: {
                        buf = new ByteArrayOutputStream();
                        out = new ObjectOutputStream(buf);
                        out.writeObject(object);
                        byArray = this.cipher().encrypt(buf.toByteArray());
                        if (out == null) break block17;
                        out.close();
                    }
                    if (buf == null) break block18;
                    buf.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (buf != null) {
                                buf.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SQLException("Problem serializing: " + object.getClass().getName(), e);
        }
    }

    /*
     * Loose catch block
     */
    private T deserialize(byte[] bytes) throws SQLException {
        if (bytes == null) {
            return null;
        }
        byte[] decrypted = this.cipher().decrypt(bytes);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Object object;
                ObjectInputStreamWithClassLoader in;
                ByteArrayInputStream buf;
                block19: {
                    block18: {
                        buf = new ByteArrayInputStream(decrypted);
                        in = new ObjectInputStreamWithClassLoader((InputStream)buf, this.classLoading);
                        object = in.readObject();
                        if (in == null) break block18;
                        in.close();
                    }
                    if (buf == null) break block19;
                    buf.close();
                }
                return (T)object;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (buf != null) {
                                buf.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SQLException("Problem deserializing: " + this.getRawType(), e);
        }
    }
}

