/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.ibatis.type.JdbcType;
import org.h2.jdbc.JdbcPreparedStatement;
import org.sonatype.nexus.datastore.mybatis.CipherAwareTypeHandler;
import org.sonatype.nexus.datastore.mybatis.SensitiveJsonFactory;
import org.sonatype.nexus.security.PasswordHelper;

public abstract class AbstractJsonTypeHandler<T>
extends CipherAwareTypeHandler<T> {
    private static final Base64Variant BASE_64 = Base64Variants.getDefaultVariant();
    private final ObjectMapper objectMapper = this.buildObjectMapper(() -> new ObjectMapper((JsonFactory)new SensitiveJsonFactory()));
    private final JavaType jsonType = this.objectMapper.constructType(this.getJsonType());

    protected AbstractJsonTypeHandler() {
    }

    protected ObjectMapper buildObjectMapper(Supplier<ObjectMapper> mapperFactory) {
        return mapperFactory.get().registerModule((Module)new JavaTimeModule());
    }

    protected Type getJsonType() {
        return this.getRawType();
    }

    protected byte[] writeToJson(Object value) throws SQLException {
        return this.writeToPlainJson(value);
    }

    @Nullable
    protected Object readFromJson(@Nullable byte[] json) throws SQLException {
        return this.readFromPlainJson(json);
    }

    protected byte[] writeToPlainJson(Object value) throws SQLException {
        try {
            return this.objectMapper.writeValueAsBytes(value);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Nullable
    protected Object readFromPlainJson(@Nullable byte[] json) throws SQLException {
        try {
            return json != null ? this.objectMapper.readValue(json, this.jsonType) : null;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    void encryptSensitiveFields(PasswordHelper passwordHelper, Predicate<String> attributeFilter) {
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        if (jsonFactory instanceof SensitiveJsonFactory) {
            ((SensitiveJsonFactory)jsonFactory).encryptSensitiveFields(passwordHelper, attributeFilter);
        }
    }

    protected final byte[] writeToEncryptedJson(Object value) throws SQLException {
        return BASE_64.encode(this.cipher().encrypt(this.writeToPlainJson(value)), true).getBytes(StandardCharsets.UTF_8);
    }

    @Nullable
    protected final Object readFromEncryptedJson(@Nullable byte[] json) throws SQLException {
        byte[] plain = json;
        if (json != null) {
            Preconditions.checkState((json.length >= 6 && json[0] == 34 ? 1 : 0) != 0, (Object)"Expected a Base64 JSON string");
            plain = this.cipher().decrypt(BASE_64.decode(new String(json, 1, json.length - 2, StandardCharsets.UTF_8)));
        }
        return this.readFromPlainJson(plain);
    }

    public final void setNonNullParameter(PreparedStatement ps, int parameterIndex, T parameter, JdbcType jdbcType) throws SQLException {
        byte[] json = this.writeToJson(parameter);
        if (ps.isWrapperFor(JdbcPreparedStatement.class)) {
            ps.setBytes(parameterIndex, json);
        } else {
            ps.setString(parameterIndex, new String(json, StandardCharsets.UTF_8));
        }
    }

    public final T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return (T)this.readFromJson(rs.getBytes(columnName));
    }

    public final T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return (T)this.readFromJson(rs.getBytes(columnIndex));
    }

    public final T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (T)this.readFromJson(cs.getBytes(columnIndex));
    }
}

