/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBytesTypeHandler<T>
extends BaseTypeHandler<T> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Supplier<T> defaultValueSupplier;

    protected AbstractBytesTypeHandler(Supplier<T> defaultValueSupplier) {
        this.defaultValueSupplier = (Supplier)Preconditions.checkNotNull(defaultValueSupplier);
    }

    public final T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.deserialize(Optional.ofNullable(rs.getBytes(columnName)));
    }

    public final T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.deserialize(Optional.ofNullable(rs.getBytes(columnIndex)));
    }

    public final T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.deserialize(Optional.ofNullable(cs.getBytes(columnIndex)));
    }

    public final void setNonNullParameter(PreparedStatement ps, int parameterIndex, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setBytes(parameterIndex, this.serialize(parameter));
    }

    protected abstract T deserialize(InputStream var1);

    private T deserialize(Optional<byte[]> blob) {
        return (T)blob.map(ByteArrayInputStream::new).map(this::deserialize).orElseGet(this.defaultValueSupplier::get);
    }

    /*
     * Loose catch block
     */
    private byte[] serialize(T object) throws SQLException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                byte[] byArray;
                ObjectOutputStream out;
                ByteArrayOutputStream buf;
                block18: {
                    block17: {
                        buf = new ByteArrayOutputStream();
                        out = new ObjectOutputStream(buf);
                        out.writeObject(object);
                        out.flush();
                        byArray = buf.toByteArray();
                        if (out == null) break block17;
                        out.close();
                    }
                    if (buf == null) break block18;
                    buf.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (buf != null) {
                                buf.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new SQLException("Problem serializing: " + object.getClass().getName(), e);
        }
    }
}

