/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api;

import java.util.concurrent.atomic.AtomicLong;
import org.sonatype.nexus.common.math.Math2;

public class OperationMetrics {
    private final AtomicLong blobSize = new AtomicLong();
    private final AtomicLong successfulRequests = new AtomicLong();
    private final AtomicLong timeOnRequests = new AtomicLong();
    private final AtomicLong errorRequests = new AtomicLong();

    public long getBlobSize() {
        return this.blobSize.get();
    }

    public long getSuccessfulRequests() {
        return this.successfulRequests.get();
    }

    public long getTimeOnRequests() {
        return this.timeOnRequests.get();
    }

    public long getErrorRequests() {
        return this.errorRequests.get();
    }

    public void setBlobSize(long blobSize) {
        this.blobSize.set(blobSize);
    }

    public void setSuccessfulRequests(long successfulRequests) {
        this.successfulRequests.set(successfulRequests);
    }

    public void setTimeOnRequests(long timeOnRequests) {
        this.timeOnRequests.set(timeOnRequests);
    }

    public void setErrorRequests(long errorRequests) {
        this.errorRequests.set(errorRequests);
    }

    public void addBlobSize(long blobSize) {
        this.blobSize.updateAndGet(size -> size + blobSize);
    }

    public void addTimeOnRequests(long timeOnRequests) {
        this.timeOnRequests.updateAndGet(time -> time + timeOnRequests);
    }

    public void addSuccessfulRequest() {
        this.successfulRequests.incrementAndGet();
    }

    public void addErrorRequest() {
        this.errorRequests.incrementAndGet();
    }

    public void clear() {
        this.blobSize.set(0L);
        this.successfulRequests.set(0L);
        this.timeOnRequests.set(0L);
        this.errorRequests.set(0L);
    }

    public OperationMetrics add(OperationMetrics operationMetrics) {
        OperationMetrics metrics = new OperationMetrics();
        metrics.setBlobSize(Math2.addClamped((long)this.blobSize.get(), (long)operationMetrics.getBlobSize()));
        metrics.setSuccessfulRequests(Math2.addClamped((long)this.successfulRequests.get(), (long)operationMetrics.getSuccessfulRequests()));
        metrics.setTimeOnRequests(Math2.addClamped((long)this.timeOnRequests.get(), (long)operationMetrics.getTimeOnRequests()));
        metrics.setErrorRequests(Math2.addClamped((long)this.errorRequests.get(), (long)operationMetrics.getErrorRequests()));
        return metrics;
    }
}

