/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.tasks.BlobStoreConsumer;
import org.sonatype.nexus.blobstore.api.tasks.BlobStoreTaskService;

@Named
public class BlobStoreTaskServiceImpl
extends ComponentSupport
implements BlobStoreTaskService {
    final List<BlobStoreConsumer> blobStoreConsumers;

    @Inject
    public BlobStoreTaskServiceImpl(List<BlobStoreConsumer> blobStoreConsumers) {
        this.blobStoreConsumers = blobStoreConsumers;
    }

    @Override
    public boolean isAnyTaskInUseForBlobStore(String blobStoreName) {
        return this.blobStoreConsumers.stream().anyMatch(blobStoreConsumer -> blobStoreConsumer.isBlobStoreInUse(blobStoreName));
    }

    @Override
    public int countTasksInUseForBlobStore(String blobStoreName) {
        return this.blobStoreConsumers.stream().map(blobStoreConsumer -> blobStoreConsumer.blobStoreUsageCount(blobStoreName)).mapToInt(Integer::intValue).sum();
    }
}

