/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.BlobId;

public class BlobRef {
    private static final String ID_MATCHER = "[\\w-]{30,}";
    private static final String CANONICAL_PATTERN = String.format("(?<store>.+)@(?<blobid>%s$)", "[\\w-]{30,}");
    private static final String ORIENT_PATTERN = String.format("(?<ostore>.+)@(%s):(?<oblobid>%s$)", "[\\w-]{30,}", "[\\w-]{30,}");
    private static final String SQL_PATTERN = String.format("(?<sstore>.+):(?<sblobid>%s)@(%s$)", "[\\w-]{30,}", "[\\w-]{30,}");
    private static final Pattern BLOB_REF_PATTERN = Pattern.compile(String.format("%s|%s|%s", ORIENT_PATTERN, SQL_PATTERN, CANONICAL_PATTERN));
    private static final String BLOB_REF_SIMPLE_FORMAT = "%s@%s";
    private final String node;
    private final String store;
    private final String blob;

    public BlobRef(String store, String blob) {
        this(null, store, blob);
    }

    public BlobRef(@Nullable String node, String store, String blob) {
        this.node = node;
        this.store = (String)Preconditions.checkNotNull((Object)store);
        this.blob = (String)Preconditions.checkNotNull((Object)blob);
    }

    public static BlobRef parse(String spec) {
        Matcher matcher = BLOB_REF_PATTERN.matcher(spec);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Not a valid blob reference");
        String store = matcher.group("store");
        if (store != null) {
            return new BlobRef(store, matcher.group("blobid"));
        }
        store = matcher.group("ostore");
        if (store != null) {
            return new BlobRef(store, matcher.group("oblobid"));
        }
        store = matcher.group("sstore");
        if (store != null) {
            return new BlobRef(store, matcher.group("sblobid"));
        }
        throw new IllegalArgumentException("Not a valid blob reference");
    }

    @Nullable
    public String getNode() {
        return this.node;
    }

    public String getStore() {
        return this.store;
    }

    public String getBlob() {
        return this.blob;
    }

    public BlobId getBlobId() {
        return new BlobId(this.getBlob());
    }

    public String toString() {
        return String.format(BLOB_REF_SIMPLE_FORMAT, this.getStore(), this.getBlob());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobRef blobRef = (BlobRef)o;
        return Objects.equals(this.blob, blobRef.blob) && Objects.equals(this.store, blobRef.store);
    }

    public int hashCode() {
        return Objects.hash(this.store, this.blob);
    }
}

