/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.orient.internal.proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.cocoapods.CocoapodsContentFacet;
import com.sonatype.nexus.repository.cocoapods.internal.AssetKind;
import com.sonatype.nexus.repository.cocoapods.internal.CocoapodsFormat;
import com.sonatype.nexus.repository.cocoapods.internal.PathUtils;
import com.sonatype.nexus.repository.cocoapods.internal.proxy.InvalidSpecFileException;
import com.sonatype.nexus.repository.cocoapods.internal.proxy.SpecFileProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class OrientCocoapodsProxyFacet
extends ProxyFacetSupport {
    private static final String ASSET_KIND_ERROR = "Received an invalid AssetKind of type: ";
    private SpecFileProcessor specFileProcessor;

    @Inject
    public OrientCocoapodsProxyFacet(SpecFileProcessor specFileProcessor) {
        this.specFileProcessor = specFileProcessor;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Content transformSpecFile(Payload payload) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream data = payload.openInputStream();){
            String specFile = IOUtils.toString((InputStream)data, (Charset)StandardCharsets.UTF_8);
            try {
                return new Content((Payload)new StringPayload(this.specFileProcessor.toProxiedSpec(specFile, URI.create(String.valueOf(this.getRepository().getUrl()) + "/")), "application/json"));
            }
            catch (InvalidSpecFileException e) {
                block12: {
                    this.log.info("Invalid Spec file", (Throwable)e);
                    if (data == null) break block12;
                    data.close();
                }
                return null;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Content get(Context context) throws IOException {
        Content ret = super.get(context);
        if (ret == null) {
            return null;
        }
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind == AssetKind.SPEC) {
            ret = this.transformSpecFile((Payload)ret);
        }
        return ret;
    }

    protected Content getCachedContent(Context context) {
        Content ret;
        String path = CocoapodsFormat.removeInitialSlashFromPath(context.getRequest().getPath());
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case CDN_METADATA: {
                if (!path.startsWith("cdn_metadata/")) {
                    ret = ((CocoapodsContentFacet)this.facet(CocoapodsContentFacet.class)).get("cdn_metadata/" + path);
                    break;
                }
            }
            case SPEC: 
            case POD: {
                ret = ((CocoapodsContentFacet)this.facet(CocoapodsContentFacet.class)).get(path);
                break;
            }
            default: {
                throw new IllegalStateException(ASSET_KIND_ERROR + assetKind.name());
            }
        }
        return ret;
    }

    protected Content store(Context context, Content content) throws IOException {
        Content ret;
        String path = CocoapodsFormat.removeInitialSlashFromPath(context.getRequest().getPath());
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        CocoapodsContentFacet cocoapodsFacet = (CocoapodsContentFacet)this.facet(CocoapodsContentFacet.class);
        switch (assetKind) {
            case CDN_METADATA: {
                ret = cocoapodsFacet.storeCdnMetadataContent("cdn_metadata/" + path, content);
                this.cacheControllerHolder.getMetadataCacheController().invalidateCache();
                break;
            }
            case SPEC: {
                ret = this.storeSpecFile(content, path);
                this.cacheControllerHolder.getMetadataCacheController().invalidateCache();
                break;
            }
            case POD: {
                ret = this.storePodFile(content, context);
                break;
            }
            default: {
                throw new IllegalStateException(ASSET_KIND_ERROR + assetKind.name());
            }
        }
        return ret;
    }

    protected String getUrl(Context context) {
        String ret;
        String path = CocoapodsFormat.removeInitialSlashFromPath(context.getRequest().getPath());
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        switch (assetKind) {
            case SPEC: 
            case CDN_METADATA: {
                ret = path;
                break;
            }
            case POD: {
                ret = this.providePodExternalUri(context);
                break;
            }
            default: {
                throw new IllegalStateException(ASSET_KIND_ERROR + assetKind.name());
            }
        }
        return ret;
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent Cocoapods asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Nonnull
    protected CacheController getCacheController(Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return (CacheController)Preconditions.checkNotNull((Object)this.cacheControllerHolder.get(assetKind.getCacheType()));
    }

    private String providePodExternalUri(Context context) {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String packageName = (String)state.getTokens().get("package_name");
        String packageVersion = (String)state.getTokens().get("package_version");
        String specAssetName = PathUtils.buildNxrmSpecFilePath(packageName, packageVersion);
        return ((CocoapodsContentFacet)this.facet(CocoapodsContentFacet.class)).getAssetFormatAttribute(specAssetName, "ccp_remote");
    }

    private Content storeSpecFile(Content content, String path) throws IOException {
        String remoteUri;
        String specFile = IOUtils.toString((InputStream)content.openInputStream(), (Charset)StandardCharsets.UTF_8);
        try {
            remoteUri = this.specFileProcessor.extractExternalUri(specFile).toString();
        }
        catch (InvalidSpecFileException e) {
            this.log.warn("Invalid spec file: {}; {}", (Object)path, (Object)e.getMessage());
            return null;
        }
        SpecFileContent contentToStore = new SpecFileContent(content.getContentType(), content.getAttributes(), specFile);
        return ((CocoapodsContentFacet)this.facet(CocoapodsContentFacet.class)).storeSpecFileContent(path, contentToStore, (Map<String, Object>)ImmutableMap.of((Object)"ccp_remote", (Object)remoteUri));
    }

    private Content storePodFile(Content content, Context context) throws IOException {
        String path = CocoapodsFormat.removeInitialSlashFromPath(context.getRequest().getPath());
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String packageName = (String)state.getTokens().get("package_name");
        String packageVersion = (String)state.getTokens().get("package_version");
        return ((CocoapodsContentFacet)this.facet(CocoapodsContentFacet.class)).storePodFileContent(path, content, packageName, packageVersion);
    }

    private static class SpecFileContent
    extends Content {
        public SpecFileContent(String contentType, AttributesMap attributesMap, String specFile) {
            super((Payload)new StringPayload(specFile, contentType), attributesMap);
        }
    }
}

