/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.repository.cocoapods.CocoapodsContentFacet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientCocoapodsFacet
extends FacetSupport
implements CocoapodsContentFacet {
    private static final List<HashAlgorithm> HASH_ALGORITHMS = Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.SHA256);

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.getRepository().facet(StorageFacet.class);
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content get(String assetPath) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)assetPath, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return null;
        }
        Content content = new Content((Payload)new BlobPayload(tx.requireBlob(asset.requireBlobRef()), asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    @TransactionalStoreBlob
    public Content storePodFileContent(String assetPath, Content content, String componentName, String componentVersion) throws IOException {
        return this.storePodFile(assetPath, content, componentName, componentVersion, null);
    }

    @Override
    @TransactionalStoreBlob
    public Content storeCdnMetadataContent(String assetPath, Content content) throws IOException {
        return this.storePodFile(assetPath, content, null, null, null);
    }

    @Override
    @TransactionalStoreBlob
    public Content storeSpecFileContent(String assetPath, Content content, @Nullable Map<String, Object> formatAttributes) throws IOException {
        return this.storePodFile(assetPath, content, null, null, formatAttributes);
    }

    private Content storePodFile(String assetPath, Content content, @Nullable String componentName, @Nullable String componentVersion, @Nullable Map<String, Object> formatAttributes) throws IOException {
        Preconditions.checkNotNull((Object)assetPath);
        Preconditions.checkNotNull((Object)content);
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, HASH_ALGORITHMS);){
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Bucket bucket = tx.findBucket(this.getRepository());
            Asset asset = tx.findAssetWithProperty("name", (Object)assetPath, bucket);
            if (asset == null) {
                if (StringUtils.isNotEmpty((String)componentName)) {
                    Component component = this.findOrCreateComponent(tx, bucket, componentName, componentVersion);
                    asset = (Asset)tx.createAsset(bucket, component).name(assetPath);
                } else {
                    asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(assetPath);
                }
            }
            Content.applyToAsset((Asset)asset, (AttributesMap)content.getAttributes());
            if (formatAttributes != null) {
                for (Map.Entry<String, Object> pair : formatAttributes.entrySet()) {
                    asset.formatAttributes().set(pair.getKey(), pair.getValue());
                }
            }
            AssetBlob blob = tx.setBlob(asset, assetPath, (InputStreamSupplier)tempBlob, HASH_ALGORITHMS, null, null, false);
            tx.saveAsset(asset);
            Content updatedContent = new Content((Payload)new BlobPayload(blob.getBlob(), asset.requireContentType()));
            Content.extractFromAsset((Asset)asset, HASH_ALGORITHMS, (AttributesMap)updatedContent.getAttributes());
            return updatedContent;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public String getAssetFormatAttribute(String assetPath, String attributeName) {
        Preconditions.checkNotNull((Object)assetPath);
        Preconditions.checkNotNull((Object)attributeName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)assetPath, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return null;
        }
        return (String)asset.formatAttributes().get(attributeName);
    }

    private Component findOrCreateComponent(StorageTx tx, Bucket bucket, String componentName, String componentVersion) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)componentName).and("version").eq((Object)componentVersion).build(), Collections.singletonList(this.getRepository()));
        Component component = (Component)Iterables.getFirst((Iterable)components, null);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(componentName)).version(componentVersion);
            tx.saveComponent(component);
        }
        return component;
    }
}

