/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="cocoapods")
public class OrientCocoapodsBrowseNodeGenerator
extends ComponentSupport
implements BrowseNodeGenerator {
    private static final String POD_PATH = "pods";

    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<BrowsePaths> paths = this.computeComponentPaths(asset, component);
            String viewName = this.cutResourceParams(this.lastSegment(asset.name()));
            BrowsePaths.appendPath(paths, (String)viewName);
            return paths;
        }
        List nameParts = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)this.cutResourceParams(asset.name()));
        return BrowsePaths.fromPaths((List)nameParts, (boolean)false);
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(POD_PATH);
        if (!Strings2.isBlank((String)component.group())) {
            paths.add(component.group());
        }
        paths.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            paths.add(component.version());
        }
        return BrowsePaths.fromPaths(paths, (boolean)true);
    }

    private String cutResourceParams(String lastSegment) {
        int ind = lastSegment.indexOf(63);
        return ind == -1 ? lastSegment : lastSegment.substring(0, ind);
    }
}

