/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.datastore.internal.proxy;

import com.sonatype.nexus.repository.cocoapods.CocoapodsContentFacet;
import com.sonatype.nexus.repository.cocoapods.datastore.internal.proxy.CocoapodsProxyFacet;
import com.sonatype.nexus.repository.cocoapods.internal.AssetKind;
import com.sonatype.nexus.repository.cocoapods.internal.CocoapodsSecurityFacet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.NegativeCacheFacet;
import org.sonatype.nexus.repository.cache.NegativeCacheHandler;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.maintenance.LastAssetMaintenanceFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyHandler;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@AvailabilityVersion(from="1.0")
@Named(value="cocoapods-proxy")
@Singleton
public class CocoapodsProxyRecipe
extends RecipeSupport {
    public static final String NAME = "cocoapods-proxy";
    @Inject
    Provider<CocoapodsProxyFacet> proxyFacet;
    @Inject
    Provider<CocoapodsContentFacet> cocoapodsFacet;
    @Inject
    Provider<CocoapodsSecurityFacet> securityFacet;
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<SearchFacet> searchFacet;
    @Inject
    Provider<HttpClientFacet> httpClientFacet;
    @Inject
    Provider<PurgeUnusedFacet> purgeUnusedFacet;
    @Inject
    Provider<NegativeCacheFacet> negativeCacheFacet;
    @Inject
    Provider<BrowseFacet> browseFacet;
    @Inject
    Provider<LastAssetMaintenanceFacet> maintenanceFacet;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    RoutingRuleHandler routingHandler;
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    NegativeCacheHandler negativeCacheHandler;
    @Inject
    PartialFetchHandler partialFetchHandler;
    @Inject
    ProxyHandler proxyHandler;
    @Inject
    ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    ContentHeadersHandler contentHeadersHandler;
    @Inject
    LastDownloadedHandler lastDownloadedHandler;
    @Inject
    HandlerContributor handlerContributor;

    @Inject
    public CocoapodsProxyRecipe(@Named(value="proxy") @Named(value="proxy") Type type, @Named(value="cocoapods") @Named(value="cocoapods") Format format) {
        super(type, format);
    }

    public void apply(Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.httpClientFacet.get());
        repository.attach((Facet)this.negativeCacheFacet.get());
        repository.attach((Facet)this.proxyFacet.get());
        repository.attach((Facet)this.cocoapodsFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.maintenanceFacet.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.purgeUnusedFacet.get());
    }

    private ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.createRoutes(builder);
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }

    private void createRoutes(Router.Builder builder) {
        this.createRoute(builder, CocoapodsProxyRecipe.createGetTokenMatcher("/Specs/{subtree:.*}"), AssetKind.SPEC);
        this.createRoute(builder, CocoapodsProxyRecipe.createGetTokenMatcher("{metadataPrefix:.*}/CocoaPods-version.yml"), AssetKind.CDN_METADATA);
        this.createRoute(builder, CocoapodsProxyRecipe.createGetTokenMatcher("{metadataPrefix:.*}/deprecated_podspecs.txt"), AssetKind.CDN_METADATA);
        this.createRoute(builder, CocoapodsProxyRecipe.createGetTokenMatcher("{metadataPrefix:.*}/all_pods{subtree:.*}.txt"), AssetKind.CDN_METADATA);
        this.createRoute(builder, CocoapodsProxyRecipe.createGetTokenMatcher(String.format("/pods/{%s}/{%s}/{filename}", "package_name", "package_version")), AssetKind.POD);
    }

    private void createRoute(Router.Builder builder, Matcher matcher, AssetKind assetKind) {
        Route.Builder route = new Route.Builder().matcher(matcher).handler((Handler)this.timingHandler).handler(this.assetKindHandler(assetKind));
        if (assetKind != AssetKind.CDN_METADATA && assetKind != AssetKind.SPEC) {
            route.handler((Handler)this.securityHandler);
            route.handler((Handler)this.handlerContributor);
        }
        route.handler((org.sonatype.nexus.repository.recipe.Handler)this.routingHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.negativeCacheHandler).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler((Handler)this.proxyHandler);
        builder.route(route.create());
    }

    private static Matcher createGetTokenMatcher(String pattern) {
        return LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"HEAD", "GET"}), new TokenMatcher(pattern)});
    }

    private Handler assetKindHandler(AssetKind assetKind) {
        return context -> {
            context.getAttributes().set(AssetKind.class, (Object)assetKind);
            return context.proceed();
        };
    }
}

