/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.cocoapods.CocoapodsContentFacet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.utils.FormatAttributesUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="cocoapods")
public class CocoapodsContentFacetImpl
extends ContentFacetSupport
implements CocoapodsContentFacet {
    private static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.MD5, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256);

    @Inject
    public CocoapodsContentFacetImpl(@Named(value="cocoapods") @Named(value="cocoapods") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    @Nullable
    public Content get(String assetPath) {
        Preconditions.checkNotNull((Object)assetPath);
        return this.assets().path(this.normalizeAssetPath(assetPath)).find().map(FluentAsset::download).orElse(null);
    }

    @Override
    public Content storePodFileContent(String assetPath, Content content, String componentName, String componentVersion) {
        FluentComponent component = this.components().name(componentName).version(componentVersion).normalizedVersion(this.versionNormalizerService().getNormalizedVersionByFormat(componentVersion, this.repository().getFormat())).getOrCreate();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = this.blobs().ingest((Payload)content, HASH_ALGORITHMS);){
            return this.assets().path(this.normalizeAssetPath(assetPath)).component((Component)component).blob(tempBlob).save().markAsCached((Payload)content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content storeCdnMetadataContent(String assetPath, Content content) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = this.blobs().ingest((Payload)content, HASH_ALGORITHMS);){
            return this.assets().path(this.normalizeAssetPath(assetPath)).blob(tempBlob).save().markAsCached((Payload)content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content storeSpecFileContent(String assetPath, Content content, Map<String, Object> formatAttributes) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest((Payload)content, HASH_ALGORITHMS);){
            FluentAsset fluentAsset = this.assets().path(this.normalizeAssetPath(assetPath)).blob(tempBlob).attributes("cocoapods", formatAttributes).save();
            return fluentAsset.markAsCached((Payload)content).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    public String getAssetFormatAttribute(String assetPath, String attributeName) {
        Preconditions.checkNotNull((Object)assetPath);
        Preconditions.checkNotNull((Object)attributeName);
        return this.assets().path(this.normalizeAssetPath(assetPath)).find().map(asset -> FormatAttributesUtils.getFormatAttributes((FluentAsset)asset).get(attributeName)).orElse(null);
    }

    private String normalizeAssetPath(String path) {
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

