/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import java.util.concurrent.atomic.AtomicReference;

public class ODatabaseRecordThreadLocal
extends ThreadLocal<ODatabaseDocumentInternal> {
    @Deprecated
    public static final InstanceHolder INSTANCE = new InstanceHolder();
    private static final AtomicReference<ODatabaseRecordThreadLocal> INST_HOLDER = new AtomicReference();

    public static ODatabaseRecordThreadLocal instance() {
        ODatabaseRecordThreadLocal dbInst = INST_HOLDER.get();
        if (dbInst != null) {
            return dbInst;
        }
        if (INST_HOLDER.get() == null) {
            Orient inst = Orient.instance();
            inst.registerListener(new OOrientListenerAbstract(){

                @Override
                public void onStartup() {
                }

                @Override
                public void onShutdown() {
                    INST_HOLDER.set(null);
                }
            });
            INST_HOLDER.compareAndSet(null, new ODatabaseRecordThreadLocal());
        }
        return INST_HOLDER.get();
    }

    @Override
    public ODatabaseDocumentInternal get() {
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)super.get();
        if (db == null) {
            if (Orient.instance().getDatabaseThreadFactory() == null) {
                throw new ODatabaseException("The database instance is not set in the current thread. Be sure to set it with: ODatabaseRecordThreadLocal.instance().set(db);");
            }
            db = Orient.instance().getDatabaseThreadFactory().getThreadDatabase();
            if (db == null) {
                throw new ODatabaseException("The database instance is not set in the current thread. Be sure to set it with: ODatabaseRecordThreadLocal.instance().set(db);");
            }
            this.set(db);
        }
        return db;
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public void set(ODatabaseDocumentInternal value) {
        super.set(value);
    }

    public ODatabaseDocumentInternal getIfDefined() {
        return (ODatabaseDocumentInternal)super.get();
    }

    public boolean isDefined() {
        return super.get() != null;
    }

    public static final class InstanceHolder {
        public ODatabaseDocumentInternal get() {
            return ODatabaseRecordThreadLocal.instance().get();
        }

        public void remove() {
            ODatabaseRecordThreadLocal.instance().remove();
        }

        public void set(ODatabaseDocumentInternal value) {
            ODatabaseRecordThreadLocal.instance().set(value);
        }

        public ODatabaseDocumentInternal getIfDefined() {
            return ODatabaseRecordThreadLocal.instance().getIfDefined();
        }

        public boolean isDefined() {
            return ODatabaseRecordThreadLocal.instance().isDefined();
        }
    }
}

