/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.datastore.api.DataAccess;

public class DataAccessModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(DataAccessModule.class);
    private final Bundle bundle;

    public DataAccessModule(Bundle bundle) {
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
    }

    protected void configure() {
        Enumeration daos = this.bundle.findEntries("/", "*DAO.class", true);
        if (daos != null) {
            Streams.stream((Iterator)Iterators.forEnumeration((Enumeration)daos)).map(URL::getPath).map(path -> path.substring(1, path.indexOf(".class"))).map(path -> path.replace('/', '.')).map(this::tryLoadClass).filter(Optional::isPresent).map(Optional::get).filter(this::isDataAccess).forEach(this::bindDataAccess);
        }
    }

    private Optional<Class<?>> tryLoadClass(String name) {
        try {
            return Optional.of(this.bundle.loadClass(name));
        }
        catch (Exception | LinkageError e) {
            log.warn("Could not load {} for DataAccess binding", (Object)name, (Object)e);
            return Optional.empty();
        }
    }

    private boolean isDataAccess(Class<?> clazz) {
        if (DataAccess.class.isAssignableFrom(clazz)) {
            return true;
        }
        log.debug("Skipping {} because it doesn't implement DataAccess", clazz);
        return false;
    }

    private void bindDataAccess(Class clazz) {
        this.bind(new DAOKey(clazz)).toInstance((Object)clazz);
    }

    private static class DAOKey
    extends Key<Class<DataAccess>> {
        DAOKey(Class<DataAccess> clazz) {
            super((Annotation)Names.named((String)clazz.getName()));
        }
    }
}

