/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extender;

import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.servlet.GuiceFilter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.extender.NexusBundleExtender;
import org.sonatype.nexus.extender.NexusContextModule;

public class NexusContextListener
implements ServletContextListener,
FrameworkListener {
    public static final int NEXUS_EXTENDER_START_LEVEL = 100;
    public static final int NEXUS_PLUGIN_START_LEVEL = 200;
    private static final List<String> SUPPORTED_EDITIONS;
    private static final String EDITIONS_PATTERN;
    private static final Pattern INSTALL_MODE_FEATURE_FLAG_PATTERN;
    private static final String EDITION = "edition";
    private static final String ENABLED = "enabled";
    private static final String FLAG = "flag";
    private static final String NEXUS_LIFECYCLE_STARTUP_PHASE = "nexus.lifecycle.startupPhase";
    private static final String NEXUS_FULL_EDITION = "nexus-full-edition";
    private static final String UNKNOWN = "unknown";
    private static final boolean HAS_PAX_EXAM;
    private static final Logger log;
    private final Map<Object, Object> nexusProperties = new ConcurrentHashMap<Object, Object>(16, 0.75f, 1);
    private final NexusBundleExtender extender;
    private BundleContext bundleContext;
    private ServletContext servletContext;
    private FeaturesService featuresService;
    private Injector injector;
    private ManagedLifecycleManager lifecycleManager;
    private ServiceRegistration<Filter> registration;
    private ManagedLifecycle.Phase startupPhase;

    static {
        boolean hasPaxExam;
        SUPPORTED_EDITIONS = Collections.unmodifiableList(Arrays.asList("oss", "pro", "pro-starter"));
        EDITIONS_PATTERN = String.format("(?<edition>(%s)(,(%s))*)", String.join((CharSequence)"|", SUPPORTED_EDITIONS), String.join((CharSequence)"|", SUPPORTED_EDITIONS));
        INSTALL_MODE_FEATURE_FLAG_PATTERN = Pattern.compile("(?:" + EDITIONS_PATTERN + ":)?featureFlag:(?<enabled>enabledByDefault:)?(?<flag>.+)");
        try {
            hasPaxExam = org.ops4j.pax.exam.util.Injector.class.isInterface();
        }
        catch (LinkageError linkageError) {
            hasPaxExam = false;
        }
        HAS_PAX_EXAM = hasPaxExam;
        log = LoggerFactory.getLogger(NexusContextListener.class);
    }

    public NexusContextListener(NexusBundleExtender extender) {
        this.extender = (NexusBundleExtender)((Object)Preconditions.checkNotNull((Object)((Object)extender)));
    }

    public void contextInitialized(ServletContextEvent event) {
        Preconditions.checkNotNull((Object)event);
        SharedMetricRegistries.getOrCreate((String)"nexus");
        this.bundleContext = this.extender.getBundleContext();
        this.servletContext = event.getServletContext();
        Map servletProperties = (Map)this.servletContext.getAttribute("nexus.properties");
        if (servletProperties == null) {
            servletProperties = System.getProperties();
        }
        this.nexusProperties.putAll(servletProperties);
        this.featuresService = (FeaturesService)this.bundleContext.getService(this.bundleContext.getServiceReference(FeaturesService.class));
        this.injector = Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{new NexusContextModule(this.bundleContext, this.servletContext, this.nexusProperties)})});
        this.extender.doStart();
        try {
            this.lifecycleManager = (ManagedLifecycleManager)this.injector.getInstance(ManagedLifecycleManager.class);
            this.checkStartupPhase();
            this.moveToPhase(ManagedLifecycle.Phase.KERNEL);
            this.bundleContext.addBundleListener((BundleListener)((SynchronousBundleListener)e -> {
                if (e.getType() == 1) {
                    ((BundleStartLevel)e.getBundle().adapt(BundleStartLevel.class)).setStartLevel(200);
                }
            }));
            String featureNames = this.selectNexusFeatures();
            if (!Strings.isNullOrEmpty((String)featureNames)) {
                this.installNexusFeatures(featureNames);
            } else {
                this.moveToPhase(ManagedLifecycle.Phase.SECURITY);
                this.registerNexusFilter();
            }
        }
        catch (Exception e2) {
            log.error("Failed to initialize context", (Throwable)e2);
            Throwables.throwIfUnchecked((Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        Preconditions.checkNotNull((Object)event);
        if (event.getType() == 8) {
            boolean continueStartup;
            block9: {
                continueStartup = true;
                try {
                    this.moveToPhase(ManagedLifecycle.Phase.CAPABILITIES);
                }
                catch (Exception e) {
                    continueStartup = false;
                    log.error("Failed to start nexus", (Throwable)e);
                    if (HAS_PAX_EXAM) break block9;
                    try {
                        this.bundleContext.getBundle(0L).stop();
                    }
                    catch (Throwable throwable) {}
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            this.registerNexusFilter();
            if (HAS_PAX_EXAM) {
                this.registerLocatorWithPaxExam((Provider<BeanLocator>)this.injector.getProvider(BeanLocator.class));
            }
            if (continueStartup) {
                try {
                    this.moveToPhase(ManagedLifecycle.Phase.TASKS);
                }
                catch (Exception e) {
                    log.warn("Scheduler did not start", (Throwable)e);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime();
        log.info("Uptime: {} ({})", (Object)PeriodFormat.getDefault().print((ReadablePeriod)new Period(uptime)), (Object)System.getProperty(NEXUS_FULL_EDITION, UNKNOWN));
        try {
            this.moveToPhase(ManagedLifecycle.Phase.OFF);
        }
        catch (Exception e) {
            log.error("Failed to stop nexus", (Throwable)e);
        }
        this.extender.doStop();
        if (this.servletContext != null) {
            this.servletContext = null;
        }
        this.injector = null;
        SharedMetricRegistries.remove((String)"nexus");
    }

    public Injector getInjector() {
        Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"Missing injector reference");
        return this.injector;
    }

    private void checkStartupPhase() {
        String startupPhaseValue = (String)this.nexusProperties.get(NEXUS_LIFECYCLE_STARTUP_PHASE);
        if (!Strings2.isEmpty((String)startupPhaseValue)) {
            try {
                this.startupPhase = ManagedLifecycle.Phase.valueOf((String)startupPhaseValue);
                log.info("Running lifecycle phases {}", EnumSet.range(ManagedLifecycle.Phase.KERNEL, this.startupPhase));
            }
            catch (IllegalArgumentException e) {
                log.error("Unknown value for {}: {}", (Object)NEXUS_LIFECYCLE_STARTUP_PHASE, (Object)startupPhaseValue);
                throw e;
            }
        } else {
            log.info("Running lifecycle phases {}", EnumSet.complementOf(EnumSet.of(ManagedLifecycle.Phase.OFF)));
        }
    }

    private void moveToPhase(ManagedLifecycle.Phase phase) throws Exception {
        if (this.startupPhase != null && phase.ordinal() > this.startupPhase.ordinal()) {
            this.lifecycleManager.to(this.startupPhase);
        } else {
            this.lifecycleManager.to(phase);
        }
    }

    private String selectNexusFeatures() {
        StringBuilder featureNames = new StringBuilder().append(this.nexusProperties.get("nexus-features"));
        try {
            Repository flagsRepository = this.featuresService.getRepository("nexus-flags-feature");
            if (flagsRepository != null) {
                String edition = ((ApplicationVersion)this.injector.getInstance(ApplicationVersion.class)).getEdition();
                Feature[] featureArray = flagsRepository.getFeatures();
                int n = featureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Feature feature = featureArray[n2];
                    if (this.isFeatureFlagEnabled(edition, feature.getInstall())) {
                        if (featureNames.length() > 0) {
                            featureNames.append(',');
                        }
                        featureNames.append(feature.getName());
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            log.warn("Problem selecting from nexus-flags-feature", (Throwable)e);
        }
        return featureNames.toString();
    }

    @VisibleForTesting
    boolean isFeatureFlagEnabled(String edition, String installMode) {
        if (installMode != null) {
            Matcher matcher = INSTALL_MODE_FEATURE_FLAG_PATTERN.matcher(installMode);
            if (matcher.matches()) {
                boolean enabled = SystemPropertiesHelper.getBoolean((String)matcher.group(FLAG), (matcher.group(ENABLED) != null ? 1 : 0) != 0);
                if (!enabled) {
                    return false;
                }
                String editions = matcher.group(EDITION);
                if (editions == null) {
                    return true;
                }
                Set<String> editionsSet = this.extractEditions(editions);
                return editionsSet.stream().anyMatch(it -> it.equalsIgnoreCase(edition));
            }
            log.warn("Malformed feature flag: '{}'", (Object)installMode);
        }
        return false;
    }

    private Set<String> extractEditions(String editions) {
        return Arrays.stream(editions.split(",")).map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void installNexusFeatures(String featureNames) throws Exception {
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        for (String name : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)featureNames)) {
            Feature feature = this.featuresService.getFeature(name);
            if (feature != null) {
                features.add(feature);
                continue;
            }
            log.warn("Missing: {}", (Object)name);
        }
        log.info("Installing: {}", features);
        LinkedHashSet<String> featureIds = new LinkedHashSet<String>(features.size());
        for (Feature f : features) {
            if (this.featuresService.isInstalled(f)) continue;
            featureIds.add(f.getId());
        }
        if (!featureIds.isEmpty()) {
            EnumSet<FeaturesService.Option> options = EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles, FeaturesService.Option.NoAutoRefreshManagedBundles);
            this.featuresService.installFeatures(featureIds, options);
        }
        log.info("Installed: {}", features);
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class);
        if (frameworkStartLevel.getStartLevel() < 200) {
            frameworkStartLevel.setStartLevel(200, new FrameworkListener[]{this});
        }
    }

    private void registerNexusFilter() {
        if (this.registration == null) {
            Filter filter = (Filter)this.injector.getInstance(GuiceFilter.class);
            Hashtable<String, String> filterProperties = new Hashtable<String, String>(Collections.singletonMap("name", "nexus"));
            this.registration = this.bundleContext.registerService(Filter.class, (Object)filter, filterProperties);
        }
    }

    private void registerLocatorWithPaxExam(final Provider<BeanLocator> locatorProvider) {
        Hashtable<String, Object> examProperties = new Hashtable<String, Object>();
        ((Dictionary)examProperties).put("service.ranking", Integer.MAX_VALUE);
        ((Dictionary)examProperties).put("name", "nexus");
        this.bundleContext.registerService(org.ops4j.pax.exam.util.Injector.class, (Object)new org.ops4j.pax.exam.util.Injector(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void injectFields(final Object target) {
                WireModule testModule = new WireModule(new Module[]{new AbstractModule(){

                    protected void configure() {
                        this.bind(BeanLocator.class).toProvider(locatorProvider);
                        this.bind(ParameterKeys.PROPERTIES).toInstance((Object)((Map)((BeanEntry)((BeanLocator)locatorProvider.get()).locate(ParameterKeys.PROPERTIES).iterator().next()).getValue()));
                        this.requestInjection(target);
                    }
                }});
                BeanLocator beanLocator = (BeanLocator)locatorProvider.get();
                synchronized (beanLocator) {
                    Guice.createInjector((Module[])new Module[]{testModule});
                }
            }
        }, examProperties);
    }
}

