/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import org.slf4j.Logger;
import org.sonatype.nexus.logging.task.ProgressTaskLogger;
import org.sonatype.nexus.logging.task.ReplicationTaskLogger;
import org.sonatype.nexus.logging.task.SeparateTaskLogTaskLogger;
import org.sonatype.nexus.logging.task.TaskLogInfo;
import org.sonatype.nexus.logging.task.TaskLogOnlyTaskLogger;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogWithProgressLogger;
import org.sonatype.nexus.logging.task.TaskLogger;
import org.sonatype.nexus.logging.task.TaskLogging;

public class TaskLoggerFactory {
    private TaskLoggerFactory() {
        throw new IllegalAccessError("Utility class");
    }

    public static TaskLogger create(Object taskObject, Logger log, TaskLogInfo taskLogInfo) {
        TaskLogging taskLogging = taskObject.getClass().getAnnotation(TaskLogging.class);
        if (taskLogging == null) {
            taskLogging = TaskLoggingDefault.class.getAnnotation(TaskLogging.class);
        }
        switch (taskLogging.value()) {
            case NEXUS_LOG_ONLY: {
                return new ProgressTaskLogger(log);
            }
            case TASK_LOG_ONLY: {
                return new TaskLogOnlyTaskLogger(log, taskLogInfo);
            }
            case REPLICATION_LOGGING: {
                return new ReplicationTaskLogger(log, taskLogInfo);
            }
            case TASK_LOG_ONLY_WITH_PROGRESS: {
                return new TaskLogWithProgressLogger(log, taskLogInfo);
            }
        }
        return new SeparateTaskLogTaskLogger(log, taskLogInfo);
    }

    @TaskLogging(value=TaskLogType.BOTH)
    private static final class TaskLoggingDefault {
        private TaskLoggingDefault() {
        }
    }
}

