/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="conan", from="1.1", to="1.2")
@DependsOn(model="security", version="1.3", checkpoint=true)
public class ConanUpgrade_1_2
extends DatabaseUpgradeSupport {
    private static final String DB_CLASS = new OClassNameBuilder().type("realm").build();
    private static final String P_REALM_NAMES = "realm_names";
    private static final String CONAN_TOKEN_REALM = ".sonatype.repository.conan.internal.security.token.ConanTokenRealm";
    private static final String CONAN_TOKEN = "ConanToken";
    private final Provider<DatabaseInstance> security;

    @Inject
    public ConanUpgrade_1_2(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> security) {
        this.security = (Provider)Preconditions.checkNotNull(security);
    }

    public void apply() throws Exception {
        ConanUpgrade_1_2.withDatabaseAndClass(this.security, (String)DB_CLASS, (db, type) -> {
            for (ODocument doc : db.browseClass(DB_CLASS)) {
                List updatedNames = ((List)doc.field(P_REALM_NAMES, OType.EMBEDDEDLIST)).stream().map(r -> r.endsWith(CONAN_TOKEN_REALM) ? CONAN_TOKEN : r).collect(Collectors.toList());
                doc.field(P_REALM_NAMES, updatedNames);
                doc.save();
            }
        });
    }
}

