/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.security.token;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.token.BearerTokenManager;

@Named
@Singleton
public class ConanTokenManager
extends BearerTokenManager {
    @Inject
    public ConanTokenManager(ApiKeyStore apiKeyStore, SecurityHelper securityHelper) {
        super(apiKeyStore, securityHelper, "ConanToken");
    }

    public String login() {
        boolean authenticated;
        Subject subject = this.securityHelper.subject();
        boolean bl = authenticated = subject.getPrincipal() != null && subject.isAuthenticated();
        if (authenticated || AnonymousHelper.isAnonymous((Subject)subject)) {
            PrincipalCollection principals = subject.getPrincipals();
            return super.createToken(principals);
        }
        return null;
    }

    public String user() {
        boolean authenticated;
        Subject subject = this.securityHelper.subject();
        boolean bl = authenticated = subject.getPrincipal() != null && subject.isAuthenticated();
        if (authenticated) {
            return subject.getPrincipals().getPrimaryPrincipal().toString();
        }
        return null;
    }
}

