/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.security;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.internal.ConanFacetUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="conan")
@Singleton
public class ConanContentValidator
implements ContentValidator {
    private static final String X_PYTHON = "text/x-python";
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public ConanContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        if (contentName != null) {
            if (contentName.endsWith(".tgz")) {
                return "application/gzip";
            }
            if (contentName.endsWith("/conanfile.py")) {
                return X_PYTHON;
            }
            if (ConanFacetUtils.isPackageSnapshot(contentName)) {
                return "application/json";
            }
            if (ConanFacetUtils.isDigest(contentName)) {
                return "application/json";
            }
        }
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, contentName, declaredContentType);
    }
}

