/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.orient.proxy.v1;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.orient.metadata.ConanHashVerifier;
import com.sonatype.repository.conan.internal.orient.metadata.ConanUrlIndexer;
import com.sonatype.repository.conan.internal.orient.proxy.v1.OrientConanProxyHelper;
import com.sonatype.repository.conan.internal.orient.utils.ConanFacetUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class ConanProxyFacet
extends ProxyFacetSupport {
    private final ConanHashVerifier hashVerifier;
    private final ConanUrlIndexer conanUrlIndexer;

    @Inject
    public ConanProxyFacet(ConanUrlIndexer conanUrlIndexer, ConanHashVerifier hashVerifier) {
        this.conanUrlIndexer = conanUrlIndexer;
        this.hashVerifier = hashVerifier;
    }

    protected void doValidate(Configuration configuration) throws Exception {
        this.log.error("doValidate with config {}", (Object)configuration);
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords conanCoords = OrientConanProxyHelper.convertFromState(state);
        String assetPath = OrientConanProxyHelper.getProxyAssetPath(conanCoords, assetKind);
        return this.getAssetContent(assetPath, context, assetKind);
    }

    @TransactionalTouchBlob
    @Nullable
    protected Content getAssetContent(String name, Context context, AssetKind assetKind) throws IOException {
        Content content;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = ConanFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        if ((content = ConanProxyFacet.toContent(asset, tx.requireBlob(asset.requireBlobRef()))) != null && (assetKind.equals((Object)AssetKind.DOWNLOAD_URL) || assetKind.equals((Object)AssetKind.DIGEST))) {
            content = new Content((Payload)new StringPayload(this.conanUrlIndexer.updateAbsoluteUrls(context, content, this.getRepository()), "application/json"));
            Content.extractFromAsset((Asset)asset, OrientConanProxyHelper.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        }
        return content;
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords conanCoords = OrientConanProxyHelper.convertFromState(state);
        if (assetKind.equals((Object)AssetKind.CONAN_PACKAGE)) {
            return this.putPackage(content, conanCoords, assetKind);
        }
        return this.putMetadata(context, content, assetKind, conanCoords);
    }

    private Content putPackage(Content content, ConanCoords coords, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), OrientConanProxyHelper.HASH_ALGORITHMS);){
            return this.doPutPackage(tempBlob, (Payload)content, coords, assetKind);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putMetadata(Context context, Content content, AssetKind assetKind, ConanCoords coords) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content.openInputStream(), OrientConanProxyHelper.HASH_ALGORITHMS);){
            if (assetKind == AssetKind.DOWNLOAD_URL || assetKind == AssetKind.DIGEST) {
                Content saveMetadata = this.doSaveMetadata(tempBlob, (Payload)content, assetKind, coords);
                return new Content((Payload)new StringPayload(this.conanUrlIndexer.updateAbsoluteUrls(context, saveMetadata, this.getRepository()), "application/json"));
            }
            return this.doSaveMetadata(tempBlob, (Payload)content, assetKind, coords);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, OrientConanProxyHelper.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    private Component getOrCreateComponent(StorageTx tx, Bucket bucket, ConanCoords coords) {
        Component component = ConanFacetUtils.findComponent(tx, this.getRepository(), coords);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).group(coords.getGroup()).name(coords.getProject())).version(OrientConanProxyHelper.getComponentVersion(coords));
            component.formatAttributes().set("baseVersion", (Object)coords.getVersion());
            component.formatAttributes().set("channel", (Object)coords.getChannel());
        }
        tx.saveComponent(component);
        return component;
    }

    @TransactionalStoreBlob
    protected Content doPutPackage(TempBlob tempBlob, Payload content, ConanCoords coords, AssetKind assetKind) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component component = this.getOrCreateComponent(tx, bucket, coords);
        String assetPath = OrientConanProxyHelper.getProxyAssetPath(coords, assetKind);
        Asset asset = ConanFacetUtils.findAsset(tx, bucket, assetPath);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.CONAN_PACKAGE.name());
        } else if (!asset.componentId().equals(EntityHelper.id((Entity)component))) {
            asset.componentId(EntityHelper.id((Entity)component));
        }
        return this.saveAsset(tx, asset, (InputStreamSupplier)tempBlob, content, null);
    }

    @TransactionalStoreBlob
    protected Content doSaveMetadata(TempBlob metadataContent, Payload payload, AssetKind assetKind, ConanCoords coords) throws IOException {
        HashCode hash = null;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Component component = this.getOrCreateComponent(tx, bucket, coords);
        String assetPath = OrientConanProxyHelper.getProxyAssetPath(coords, assetKind);
        Asset asset = ConanFacetUtils.findAsset(tx, bucket, assetPath);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(assetPath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind.name());
            hash = this.hashVerifier.lookupHashFromAsset(tx, bucket, assetPath);
        } else if (!asset.componentId().equals(EntityHelper.id((Entity)component))) {
            asset.componentId(EntityHelper.id((Entity)component));
        }
        return this.saveAsset(tx, asset, (InputStreamSupplier)metadataContent, payload, hash);
    }

    private Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, Payload payload, HashCode hash) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return this.saveAsset(tx, asset, contentSupplier, contentType, contentAttributes, hash);
    }

    private Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, AttributesMap contentAttributes, HashCode hash) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, OrientConanProxyHelper.HASH_ALGORITHMS, null, contentType, false);
        if (!this.hashVerifier.verify(hash, (HashCode)assetBlob.getHashes().get(HashAlgorithm.MD5))) {
            return null;
        }
        asset.markAsDownloaded();
        tx.saveAsset(asset);
        return ConanProxyFacet.toContent(asset, assetBlob.getBlob());
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) {
    }

    protected String getUrl(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (OrientConanProxyHelper.DOWNLOAD_ASSET_KINDS.contains((Object)assetKind)) {
            return context.getRequest().getPath().substring(1);
        }
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coords = OrientConanProxyHelper.convertFromState(state);
        if (assetKind == AssetKind.CONAN_MANIFEST) {
            return this.getUrlForConanManifest(coords);
        }
        this.log.info("AssetKind {} to be fetched is {}", (Object)assetKind, (Object)context.getRequest().getPath());
        String download_urls = OrientConanProxyHelper.getProxyAssetPath(coords, AssetKind.DOWNLOAD_URL);
        return this.getUrlFromDownloadAsset(download_urls, assetKind.getFilename());
    }

    @TransactionalTouchBlob
    @Nullable
    protected String getUrlForConanManifest(ConanCoords coords) {
        String downloadUrlsAssetPath = OrientConanProxyHelper.getProxyAssetPath(coords, AssetKind.DOWNLOAD_URL);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset downloadUrlAsset = ConanFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), downloadUrlsAssetPath);
        if (downloadUrlAsset == null) {
            String digestAssetPath = OrientConanProxyHelper.getProxyAssetPath(coords, AssetKind.DIGEST);
            Asset digest = ConanFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), digestAssetPath);
            if (digest == null) {
                throw new IllegalStateException("DIGEST not found");
            }
            return this.conanUrlIndexer.findUrl(tx.requireBlob(digest.blobRef()).getInputStream(), AssetKind.CONAN_MANIFEST.getFilename());
        }
        return this.conanUrlIndexer.findUrl(tx.requireBlob(downloadUrlAsset.blobRef()).getInputStream(), AssetKind.CONAN_MANIFEST.getFilename());
    }

    @TransactionalTouchBlob
    protected String getUrlFromDownloadAsset(String download_urls, String find) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = ConanFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), download_urls);
        if (asset == null) {
            return null;
        }
        return this.conanUrlIndexer.findUrl(tx.requireBlob(asset.blobRef()).getInputStream(), find);
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return (CacheController)Preconditions.checkNotNull((Object)this.cacheControllerHolder.get(assetKind.getCacheType()));
    }
}

