/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.orient.metadata;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.internal.metadata.ConanManifest;
import com.sonatype.repository.conan.internal.orient.utils.ConanFacetUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;

public class ConanHashVerifier
extends ComponentSupport {
    public HashCode lookupHashFromAsset(StorageTx tx, Bucket bucket, String assetPath) {
        String filename;
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)bucket);
        Preconditions.checkNotNull((Object)assetPath);
        AttributesMap attributes = this.getConanmanifestHashes(tx, bucket, assetPath);
        if (attributes != null && attributes.contains(filename = ConanHashVerifier.getFilenameFromPath(assetPath))) {
            return HashCode.fromString((String)((String)attributes.get(filename)));
        }
        return null;
    }

    private AttributesMap getConanmanifestHashes(StorageTx tx, Bucket bucket, String assetPath) {
        String originalFilename = ConanHashVerifier.getFilenameFromPath(assetPath);
        String manifestFile = assetPath.replace(originalFilename, AssetKind.CONAN_MANIFEST.getFilename());
        Asset asset = ConanFacetUtils.findAsset(tx, bucket, manifestFile);
        if (asset == null) {
            return null;
        }
        return ConanManifest.parse(tx.getBlob(asset.blobRef()).getInputStream());
    }

    private static String getFilenameFromPath(String assetPath) {
        String[] split = assetPath.split("/");
        return split[split.length - 1];
    }

    public boolean verify(HashCode me, HashCode you) {
        return me == null || you == null || me.equals((Object)you);
    }
}

