/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.orient.hosted;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.hosted.ConanHostedHelper;
import com.sonatype.repository.conan.internal.orient.utils.ConanFacetUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

public class ConanHostedMetadataFacetSupport
extends FacetSupport {
    private static final List<AssetKind> DOWNLOAD_URL_ASSET_KINDS = Collections.unmodifiableList(Arrays.asList(AssetKind.CONAN_EXPORT, AssetKind.CONAN_FILE, AssetKind.CONAN_SOURCES, AssetKind.CONAN_MANIFEST));
    private static final List<AssetKind> DOWNLOAD_URL_PACKAGE_ASSET_KINDS = Collections.unmodifiableList(Arrays.asList(AssetKind.CONAN_PACKAGE, AssetKind.CONAN_INFO, AssetKind.CONAN_MANIFEST));

    private Map<String, String> generateDownloadUrls(List<AssetKind> assetKinds, ConanCoords coords) {
        Repository repository = this.getRepository();
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return assetKinds.stream().filter(x -> tx.assetExists(ConanHostedHelper.getHostedAssetPath(coords, x), repository)).collect(Collectors.toMap(AssetKind::getFilename, x -> String.valueOf(repository.getUrl()) + "/" + ConanHostedHelper.getHostedAssetPath(coords, x)));
    }

    @Nullable
    public String generateDownloadPackagesUrlsAsJson(ConanCoords coords) throws JsonProcessingException {
        Map<String, String> downloadUrls = this.generateDownloadUrls(DOWNLOAD_URL_PACKAGE_ASSET_KINDS, coords);
        if (downloadUrls.isEmpty()) {
            return null;
        }
        return ConanHostedHelper.MAPPER.writeValueAsString(downloadUrls);
    }

    @Nullable
    public String generateDownloadUrlsAsJson(ConanCoords coords) throws JsonProcessingException {
        Map<String, String> downloadUrls = this.generateDownloadUrls(DOWNLOAD_URL_ASSET_KINDS, coords);
        if (downloadUrls.isEmpty()) {
            return null;
        }
        return ConanHostedHelper.MAPPER.writeValueAsString(downloadUrls);
    }

    public String generateDigestAsJson(ConanCoords coords, String repositoryUrl) throws JsonProcessingException {
        HashMap<String, String> digest = new HashMap<String, String>();
        digest.put(AssetKind.CONAN_MANIFEST.getFilename(), String.valueOf(repositoryUrl) + "/" + ConanHostedHelper.getHostedAssetPath(coords, AssetKind.CONAN_MANIFEST));
        return ConanHostedHelper.MAPPER.writeValueAsString(digest);
    }

    @Nullable
    public String generatePackageSnapshotAsJson(ConanCoords coords) throws JsonProcessingException {
        Map<String, String> downloadUrls = DOWNLOAD_URL_PACKAGE_ASSET_KINDS.stream().collect(Collectors.toMap(AssetKind::getFilename, x -> ConanHostedHelper.getHostedAssetPath(coords, x)));
        Map<String, String> packageSnapshot = downloadUrls.entrySet().stream().flatMap(entry -> {
            String value = (String)entry.getValue();
            String hash = this.getHash(value);
            if (hash != null) {
                return Stream.of(Pair.of((Object)((String)entry.getKey()), (Object)hash));
            }
            return Stream.empty();
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        if (packageSnapshot.isEmpty()) {
            return null;
        }
        return ConanHostedHelper.MAPPER.writeValueAsString(packageSnapshot);
    }

    @Nullable
    @TransactionalTouchBlob
    public String getHash(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = ConanFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        HashCode checksum = asset.getChecksum(HashAlgorithm.MD5);
        if (checksum == null) {
            return null;
        }
        return checksum.toString();
    }
}

