/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class ConanManifest {
    private static final Logger LOGGER = Loggers.getLogger(ConanManifest.class);

    private ConanManifest() {
    }

    public static AttributesMap parse(InputStream conanManifestContentStream) {
        AttributesMap attributesMap = new AttributesMap();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conanManifestContentStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] split = line.split(":");
                    if (split.length != 2) continue;
                    attributesMap.set(split[0].trim(), (Object)split[1].trim());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            LOGGER.warn("Unable to convertKeys manifest file");
        }
        return attributesMap;
    }

    public static AttributesMap parse(TempBlob blob) {
        return ConanManifest.parse(blob.get());
    }
}

