/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.search.table;

import com.sonatype.repository.conan.internal.ConanFacetUtils;
import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Singleton
@Named(value="conan")
public class ConanSearchCustomFieldContributor
implements SearchCustomFieldContributor {
    public void populateSearchCustomFields(SearchRecord searchTableData, Asset asset) {
        Component component = asset.component().orElse(null);
        if (component != null) {
            Object formatAttributes = component.attributes().get("conan");
            Object assetAttributes = asset.attributes().get("conan");
            Map attributes = formatAttributes instanceof Map ? (Map)formatAttributes : Collections.emptyMap();
            searchTableData.addFormatFieldValue1((String)attributes.get("baseVersion"));
            searchTableData.addFormatFieldValue2((String)attributes.get("channel"));
            searchTableData.addFormatFieldValue3((String)attributes.get("revision"));
            Map assetAttributesMap = assetAttributes instanceof Map ? (Map)assetAttributes : Collections.emptyMap();
            searchTableData.addFormatFieldValue4((String)assetAttributesMap.get("packageId"));
            searchTableData.addFormatFieldValue5((String)assetAttributesMap.get("packageRevision"));
        }
    }

    public boolean isEnableSearchByPath(String path) {
        return !ConanFacetUtils.isPackagePath(path);
    }
}

